/*
 * Decompiled with CFR 0.152.
 */
package com.ohaotian.plugin.common.config;

import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.file.Path;
import java.nio.file.Paths;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.ApplicationContextInitializer;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.stereotype.Component;

@ConditionalOnProperty(value={"apollo.bootstrap.enabled"})
@Component
public class TongWebListener
implements ApplicationContextInitializer<ConfigurableApplicationContext> {
    private static final Logger log = LoggerFactory.getLogger(TongWebListener.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void downloadFile(String fileURL, String destinationDir) throws Exception {
        HttpURLConnection httpConn;
        block18: {
            URL url = new URL(fileURL);
            httpConn = (HttpURLConnection)url.openConnection();
            int responseCode = httpConn.getResponseCode();
            if (responseCode == 200) {
                String fileName = Paths.get(url.getPath(), new String[0]).getFileName().toString();
                Path destinationPath = Paths.get(destinationDir, fileName);
                File destinationFile = destinationPath.toFile();
                File destinationDirFile = destinationFile.getParentFile();
                if (!destinationDirFile.exists()) {
                    destinationDirFile.mkdirs();
                }
                try (InputStream inputStream = httpConn.getInputStream();
                     FileOutputStream outputStream = new FileOutputStream(destinationFile);){
                    int bytesRead;
                    byte[] buffer = new byte[4096];
                    while ((bytesRead = inputStream.read(buffer)) != -1) {
                        ((OutputStream)outputStream).write(buffer, 0, bytesRead);
                    }
                    log.info("File saved to: " + destinationPath.toString());
                    break block18;
                }
            }
            log.warn("No file to download. Server replied HTTP code: " + responseCode);
        }
        httpConn.disconnect();
    }

    public void initialize(ConfigurableApplicationContext context) {
        ConfigurableEnvironment environment = context.getEnvironment();
        String url = environment.getProperty("plugin.tongweb.license.url");
        String dir = environment.getProperty("plugin.tongweb.license.dir");
        if (StringUtils.isNotBlank((CharSequence)url)) {
            try {
                TongWebListener.downloadFile(url, dir);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }
}

