package com.ohaotian.plugin.common.util;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import javax.sql.DataSource;

import com.ohaotian.plugin.base.bo.TopologyBO;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/** <p>
 * 标题:
 * </p>
 * <p>
 * 描述:
 * </p>
 * <p>
 * 公司: www.tydic.com
 * </p>
 * 
 * @autho liuce
 * @time 2016-6-12 下午12:40:44 */
public class DbUtils {

	private static Logger           log = LoggerFactory.getLogger(DbUtils.class);

	/** 数据源 */
	private DataSource              mysqlDataSource;

	/** 取数据库分片数 */
	private static int              shardingTotalCount;

	/** 获取所有分库节点的sql */
	private String                  showNodesSql;

	/** 所有的节点信息 */
	private static List<TopologyBO> topologys;

	/** 返回 private
	 * 
	 * @return private */
	public DataSource getMysqlDataSource() {
		return mysqlDataSource;
	}

	/** 设置 private
	 * 
	 * @param mysqlDataSource
	 *        private */
	public void setMysqlDataSource(DataSource mysqlDataSource) {
		this.mysqlDataSource = mysqlDataSource;
	}

	public static int getShardingTotalCount() {
		return shardingTotalCount;
	}

	public void setShowNodesSql(String showNodesSql) {
		this.showNodesSql = showNodesSql;
	}

	/** 获取所有的节点信息<br>
	 * 适用场景: <br>
	 * 调用方式: <br>
	 * 业务逻辑说明<br>
	 * 
	 * @return
	 * @autho liuce
	 * @time 2017年5月26日 上午10:39:38 */
	public List<TopologyBO> getTopologys() {
		return topologys;
	}

	/** 获取hit语句<br>
	 * 适用场景: <br>
	 * 调用方式: <br>
	 * 业务逻辑说明<br>
	 * 
	 * @param id
	 * @return
	 * @autho liuce
	 * @time 2017年5月26日 上午10:41:54 */
	public static String getHitSql(int id) {
		TopologyBO bo = topologys.get(id);
		String hitSql = "/*TDDL:node='" + bo.getGroupName() + "'*/";
		return hitSql;
	}

	public void init() {
		try {
			List<Map<String, Object>> list = getQueryList(showNodesSql, null);
			topologys = new ArrayList<TopologyBO>(list.size());
			shardingTotalCount = list.size();
			for (Map<String, Object> map : list) {
				TopologyBO bo = new TopologyBO();
				bo.setGroupName(map.get("GROUP_NAME").toString());
				bo.setId(Integer.parseInt(map.get("ID").toString()));
				bo.setTableName(map.get("TABLE_NAME").toString());
				topologys.add(bo);
			}
		}
		catch (Exception e) {
			log.error("执行获取分库的sql出错了！", e);
		}
	}

	/** 该语句必须是一个 SQL INSERT、UPDATE 或 DELETE 语句
	 * 
	 * @param sql
	 * @param paramList
	 *        ：参数，与SQL语句中的占位符一一对应
	 * @return
	 * @throws Exception */
	public int execute(String sql, List<Object> paramList) throws Exception {
		if (sql == null || sql.trim().equals("")) {
			// logger.info("parameter is valid!");
		}

		Connection conn = null;
		PreparedStatement pstmt = null;
		int result = 0;
		try {
			conn = getConnection();
			pstmt = DbUtils.getPreparedStatement(conn, sql);
			setPreparedStatementParam(pstmt, paramList);
			if (pstmt == null) {
				return -1;
			}
			result = pstmt.executeUpdate();
		}
		catch (Exception e) {
			// logger.info(e.getMessage());
			throw new Exception(e);
		}
		finally {
			closeStatement(pstmt);
			closeConn(conn);
		}

		return result;
	}

	/** 将查询数据库获得的结果集转换为Map对象
	 * 
	 * @param sql
	 *        ：查询语句
	 * @param paramList
	 *        ：参数
	 * @return */
	public List<Map<String, Object>> getQueryList(String sql, List<Object> paramList) throws Exception {
		if (sql == null || sql.trim().equals("")) {
			// logger.info("parameter is valid!");
			return null;
		}

		Connection conn = null;
		PreparedStatement pstmt = null;
		ResultSet rs = null;
		List<Map<String, Object>> queryList = null;
		try {
			conn = getConnection();
			pstmt = DbUtils.getPreparedStatement(conn, sql);
			setPreparedStatementParam(pstmt, paramList);
			if (pstmt == null) {
				return null;
			}
			// 设置为真正的流式读取方式
			pstmt.setFetchSize(Integer.MIN_VALUE);
			rs = getResultSet(pstmt);
			queryList = getQueryList(rs);
		}
		catch (RuntimeException e) {
			// logger.info(e.getMessage());
			System.out.println("parameter is valid!");
			throw new Exception(e);
		}
		finally {
			closeResultSet(rs);
			closeStatement(pstmt);
			closeConn(conn);
		}
		return queryList;
	}

	public void setPreparedStatementParam(PreparedStatement pstmt, List<Object> paramList) throws Exception {
		if (pstmt == null || paramList == null || paramList.isEmpty()) {
			return;
		}
		DateFormat df = DateFormat.getDateTimeInstance();
		for (int i = 0; i < paramList.size(); i++) {
			if (paramList.get(i) instanceof Integer) {
				int paramValue = ((Integer) paramList.get(i)).intValue();
				pstmt.setInt(i + 1, paramValue);
			}
			else if (paramList.get(i) instanceof Float) {
				float paramValue = ((Float) paramList.get(i)).floatValue();
				pstmt.setFloat(i + 1, paramValue);
			}
			else if (paramList.get(i) instanceof Double) {
				double paramValue = ((Double) paramList.get(i)).doubleValue();
				pstmt.setDouble(i + 1, paramValue);
			}
			else if (paramList.get(i) instanceof Date) {
				pstmt.setString(i + 1, df.format((Date) paramList.get(i)));
			}
			else if (paramList.get(i) instanceof Long) {
				long paramValue = ((Long) paramList.get(i)).longValue();
				pstmt.setLong(i + 1, paramValue);
			}
			else if (paramList.get(i) instanceof String) {
				pstmt.setString(i + 1, (String) paramList.get(i));
			}
		}
	}

	/** 获得数据库连接
	 * 
	 * @return
	 * @throws Exception */
	public Connection getConnection() throws Exception {
		return mysqlDataSource.getConnection();
	}

	public static PreparedStatement getPreparedStatement(Connection conn, String sql) throws Exception {
		if (conn == null || sql == null || sql.trim().equals("")) {
			return null;
		}
		PreparedStatement pstmt = conn.prepareStatement(sql.trim());
		return pstmt;
	}

	/** 获得数据库查询结果集
	 * 
	 * @param pstmt
	 * @return
	 * @throws Exception */
	private ResultSet getResultSet(PreparedStatement pstmt) throws Exception {
		if (pstmt == null) {
			return null;
		}
		ResultSet rs = pstmt.executeQuery();
		return rs;
	}

	/** @param rs
	 * @return
	 * @throws Exception */
	private List<Map<String, Object>> getQueryList(ResultSet rs) throws Exception {
		if (rs == null) {
			return null;
		}
		ResultSetMetaData rsMetaData = rs.getMetaData();
		int columnCount = rsMetaData.getColumnCount();
		List<Map<String, Object>> dataList = new ArrayList<Map<String, Object>>();
		while (rs.next()) {
			Map<String, Object> dataMap = new HashMap<String, Object>();
			for (int i = 0; i < columnCount; i++) {
				dataMap.put(rsMetaData.getColumnName(i + 1), rs.getObject(i + 1));
			}
			dataList.add(dataMap);
		}
		return dataList;
	}

	/** 关闭数据库连接
	 * 
	 * @param conn */
	public void closeConn(Connection conn) {
		if (conn == null) {
			return;
		}
		try {
			conn.close();
		}
		catch (SQLException e) {
			// logger.info(e.getMessage());
		}
	}

	/** 关闭
	 * 
	 * @param stmt */
	public void closeStatement(Statement stmt) {
		if (stmt == null) {
			return;
		}
		try {
			stmt.close();
		}
		catch (SQLException e) {
			// logger.info(e.getMessage());
		}
	}

	/** 关闭
	 * 
	 * @param rs */
	public void closeResultSet(ResultSet rs) {
		if (rs == null) {
			return;
		}
		try {
			rs.close();
		}
		catch (SQLException e) {
			// logger.info(e.getMessage());
		}
	}

}
