package com.ohaotian.plugin.common.util;

import javax.validation.ConstraintViolation;
import javax.validation.Path;
import javax.validation.Validation;
import javax.validation.Validator;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;

/**
 * 
  * @类名称：ValidationUtil  
  * @类描述：校验入参
  * @创建人：liubinqi  
  * @创建时间：2017年8月27日 下午4:36:26  
  * @修改人：liubinqi  
  * @修改时间：2017年8月27日 下午4:36:26  
  * @修改备注：
  * @Company:天源迪科(C) 2017
  * @version 1.0
 */
public class ValidationUtil {


	public static List<ValidationResult> validateModel(Object obj) {// 验证某一个对象

		List<ValidationResult> list =new LinkedList<>();

		Validator validator = Validation.buildDefaultValidatorFactory().getValidator();
		//验证某个对象,其实也可以只验证其中的某一个属性的
		Set<ConstraintViolation<Object>> constraintViolations = validator.validate(obj);
		Iterator<ConstraintViolation<Object>> iter = constraintViolations.iterator();
		while (iter.hasNext()) {
			ValidationResult vr=new ValidationResult();
			ConstraintViolation<Object> next = iter.next();
			String message = next.getMessage();
			Path propertyPath = next.getPropertyPath();
			vr.setPropertyName(propertyPath.toString());
			vr.setValidationMsg(message);
			list.add(vr);
		}
		return list;
	}
}


