package com.ohaotian.plugin.db;

import org.apache.ibatis.executor.resultset.ResultSetHandler;
import org.apache.ibatis.plugin.Interceptor;
import org.apache.ibatis.plugin.Intercepts;
import org.apache.ibatis.plugin.Signature;
import org.apache.ibatis.plugin.*;

import java.lang.reflect.Field;
import java.math.BigDecimal;
import java.sql.Statement;
import java.util.Properties;

/**
 * 标题：类名称:BigDecimalFormatInterceptor
 * 说明：处理当decimal是0的时候，返回科学计数法
 * 时间：2023/8/30 11:27 AM
 * 作者 @author hegy2017
 */
@Intercepts({
        @Signature(
                type = ResultSetHandler.class,
                method = "handleResultSets",
                args = { Statement.class }
        )
})
public class BigDecimalFormatInterceptor implements Interceptor {
    @Override
    public Object intercept(Invocation invocation) throws Throwable {
        Object result = invocation.proceed();

        if (result instanceof java.util.ArrayList) {
            java.util.ArrayList resultList = (java.util.ArrayList) result;
            for (Object object : resultList) {

                if (object != null) {
                    Class<?> clazz = object.getClass();
                    Field[] fields = clazz.getDeclaredFields();
                    for (Field field : fields) {
                        if (field.getType() == BigDecimal.class) {
                            field.setAccessible(true);
                            BigDecimal value = (BigDecimal) field.get(object);
                            if(value!=null){
                                if(value.compareTo(BigDecimal.ZERO) == 0){
                                    field.set(object, BigDecimal.ZERO);
                                }else{
                                    BigDecimal newValue = value.setScale(8, BigDecimal.ROUND_HALF_UP);
                                    field.set(object, newValue);
                                }
                            }
                        }
                    }
                }
            }
        }

        return result;
    }

    @Override
    public Object plugin(Object target) {
        return Plugin.wrap(target, this);
    }

    @Override
    public void setProperties(Properties properties) {

    }
}
