package com.ohaotian.plugin.db;

import org.apache.ibatis.executor.statement.StatementHandler;
import org.apache.ibatis.mapping.BoundSql;
import org.apache.ibatis.mapping.ParameterMapping;
import org.apache.ibatis.plugin.*;

import java.sql.Connection;
import java.util.List;
import java.util.Properties;

/**
 * 标题：类名称:PreventNoWhereConditionInterceptor
 * 说明：描述一下类的作用TODO
 * 时间：2024/4/26 11:01 AM
 * 作者 @author hegy2017
 */
@Intercepts({
        @Signature(type = StatementHandler.class, method = "prepare", args = {Connection.class, Integer.class})
})
public class PreventNoWhereConditionInterceptor implements Interceptor {
    @Override
    public Object intercept(Invocation invocation) throws Throwable {
        StatementHandler statementHandler = (StatementHandler) invocation.getTarget();
        BoundSql boundSql = statementHandler.getBoundSql();

        // 获取解析后的SQL语句
        String sql = boundSql.getSql();

        // 检查是否为UPDATE或DELETE语句
        if ((sql.toUpperCase().contains("UPDATE") || sql.toUpperCase().contains("DELETE"))) {

            // 检查是否有WHERE子句，除了WHERE 1=1
            if(!sql.toUpperCase().contains("WHERE")) {
                throw new RuntimeException("no valid where condition found for update or delete statement!:"+sql);
            }
            // 检查SQL中是否只有"where 1=1"
            boolean hasWhereClause = sql.trim().toLowerCase().endsWith("WHERE 1=1");
            if (hasWhereClause) {
                throw new RuntimeException("where condition only found 1=1  for update or delete statement!:"+sql);
            }
            // 获取SQL参数列表
            List<ParameterMapping> parameterMappings = boundSql.getParameterMappings();
            // 检查是否带了参数，如果没有带参数，也不能执行
            if(parameterMappings.size()<1){
                hasWhereClause = true;
            }
            // 如果没有WHERE子句或其他过滤条件，则抛出异常
            if (hasWhereClause) {
                throw new RuntimeException("Update or delete statement without WHERE condition is not allowed!:"+sql);
            }
        }

        // 继续执行原SQL语句
        return invocation.proceed();
    }

    @Override
    public Object plugin(Object target) {
        return Plugin.wrap(target, this);
    }

    @Override
    public void setProperties(Properties properties) {

    }
}
