package com.ohaotian.plugin.db;

import static com.ohaotian.plugin.db.utils.RandomUtil.randomCenterId;
import static com.ohaotian.plugin.db.utils.RandomUtil.randomMachineID;

/**
 * 使用SnowFlake算法用来生成64位的ID，刚好可以用long整型存储，能够用于分布式系统中生产唯一的ID， 并且生成的ID有大致的顺序。
 */
public class Sequence {

    private static int MAX_ID_NUM = 1 << 12;

    private static SnowFlake snowFlake;

    private static Sequence ourInstance = new Sequence();

    public static Sequence getInstance() {
        return ourInstance;
    }

    private Sequence() {
        this.snowFlake = new SnowFlake(randomCenterId(), randomMachineID());
    }

    /**
     * @return 返回64位大致有序的ID
     */
    public long nextId() {
        return this.snowFlake.nextId();
    }

    /**
     * 批量获取ID。
     * <p>
     * 由于使用SnowFlake算法，同一毫秒内可以生成4096个ID，为了避免毫秒内重复，所以添加此限制。
     *
     * @param idNum 一次获取ID的数量
     * @return
     */
    public long[] nextIds(int idNum) {
        if (idNum > MAX_ID_NUM) {
            throw new IllegalArgumentException("The number of Id can't be greater than " + MAX_ID_NUM);
        }
        long[] ids = new long[idNum];
        for (int i = 0; i < idNum; i++) {
            ids[i] = this.snowFlake.nextId();
        }
        return ids;
    }

}
