/*
 * Decompiled with CFR 0.152.
 */
package com.ohaotian.plugin.db;

import java.lang.reflect.Field;
import java.math.BigDecimal;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Properties;
import org.apache.ibatis.executor.resultset.ResultSetHandler;
import org.apache.ibatis.plugin.Interceptor;
import org.apache.ibatis.plugin.Intercepts;
import org.apache.ibatis.plugin.Invocation;
import org.apache.ibatis.plugin.Plugin;
import org.apache.ibatis.plugin.Signature;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Intercepts(value={@Signature(type=ResultSetHandler.class, method="handleResultSets", args={Statement.class})})
public class BigDecimalFormatInterceptor
implements Interceptor {
    private static final Logger log = LoggerFactory.getLogger(BigDecimalFormatInterceptor.class);

    public Object intercept(Invocation invocation) throws Throwable {
        Object result = invocation.proceed();
        if (result instanceof ArrayList) {
            ArrayList resultList = (ArrayList)result;
            for (Object object : resultList) {
                Field[] fields;
                if (object == null) continue;
                Class<?> clazz = object.getClass();
                for (Field field : fields = clazz.getDeclaredFields()) {
                    try {
                        if (field.getType() != BigDecimal.class) continue;
                        field.setAccessible(true);
                        BigDecimal value = (BigDecimal)field.get(object);
                        if (value == null) continue;
                        if (BigDecimal.ZERO.equals(value)) {
                            BigDecimal nonZeroValue = new BigDecimal("0.0");
                            field.set(object, nonZeroValue);
                            continue;
                        }
                        BigDecimal newValue = value.setScale(8, 4);
                        field.set(object, newValue);
                    }
                    catch (Exception e) {
                        log.error("BigDecimalFormatInterceptor\u8f6c\u6362\u5931\u8d25\uff1a" + e.getMessage());
                    }
                }
            }
        }
        return result;
    }

    public Object plugin(Object target) {
        return Plugin.wrap((Object)target, (Interceptor)this);
    }

    public void setProperties(Properties properties) {
    }
}

