/*
 * Decompiled with CFR 0.152.
 */
package com.ohaotian.plugin.db;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class PostgreSqlPageHelper {
    public static String getCountString(String querySelect) {
        if (querySelect.toLowerCase().contains("union")) {
            return "select count(*) as count from (" + querySelect + ") t";
        }
        int orderIndex = PostgreSqlPageHelper.getLastOrderInsertPoint(querySelect);
        int formIndex = PostgreSqlPageHelper.getAfterFormInsertPoint(querySelect);
        String select = querySelect.substring(0, formIndex);
        return new StringBuffer(querySelect.length()).append("select count(1) as count from (").append(querySelect.substring(0, orderIndex)).append(") t").toString();
    }

    private static String removeOrderByClause(String querySelect) {
        int orderByIndex = (querySelect = querySelect.replaceAll("\\s+", " ")).toUpperCase().indexOf("ORDER BY");
        if (orderByIndex != -1) {
            int limitIndex = querySelect.toUpperCase().indexOf("LIMIT");
            if (limitIndex != -1 && limitIndex > orderByIndex) {
                String processedSql = querySelect.substring(0, limitIndex);
                return processedSql;
            }
            String processedSql = querySelect.substring(0, orderByIndex);
            return processedSql;
        }
        return querySelect;
    }

    private static int getLastOrderInsertPoint(String querySelect) {
        int orderIndex = querySelect.toLowerCase().lastIndexOf("order by");
        if (orderIndex == -1) {
            orderIndex = querySelect.length();
        }
        if (!PostgreSqlPageHelper.isBracketCanPartnership(querySelect.substring(orderIndex, querySelect.length()))) {
            throw new RuntimeException("My SQL \u5206\u9875\u5fc5\u987b\u8981\u6709Order by \u8bed\u53e5!");
        }
        return orderIndex;
    }

    public static String getLimitString(String querySelect, int offset, int limit) {
        querySelect = PostgreSqlPageHelper.getLineSql(querySelect);
        return querySelect + " LIMIT " + limit + " OFFSET " + offset;
    }

    private static String getLineSql(String sql) {
        return sql.replaceAll("[\r\n]", " ").replaceAll("\\s{2,}", " ");
    }

    private static int getAfterFormInsertPoint(String querySelect) {
        String regex = "\\s+FROM\\s+";
        Pattern pattern = Pattern.compile(regex, 2);
        Matcher matcher = pattern.matcher(querySelect);
        while (matcher.find()) {
            int fromStartIndex = matcher.start(0);
            String text = querySelect.substring(0, fromStartIndex);
            if (!PostgreSqlPageHelper.isBracketCanPartnership(text)) continue;
            return fromStartIndex;
        }
        return 0;
    }

    private static boolean isBracketCanPartnership(String text) {
        return text != null && PostgreSqlPageHelper.getIndexOfCount(text, '(') == PostgreSqlPageHelper.getIndexOfCount(text, ')');
    }

    private static int getIndexOfCount(String text, char ch) {
        int count = 0;
        for (int i = 0; i < text.length(); ++i) {
            count = text.charAt(i) == ch ? count + 1 : count;
        }
        return count;
    }
}

