/*
 * Decompiled with CFR 0.152.
 */
package com.ohaotian.plugin.db;

import java.sql.Connection;
import java.util.List;
import java.util.Properties;
import org.apache.ibatis.executor.statement.StatementHandler;
import org.apache.ibatis.mapping.BoundSql;
import org.apache.ibatis.plugin.Interceptor;
import org.apache.ibatis.plugin.Intercepts;
import org.apache.ibatis.plugin.Invocation;
import org.apache.ibatis.plugin.Plugin;
import org.apache.ibatis.plugin.Signature;

@Intercepts(value={@Signature(type=StatementHandler.class, method="prepare", args={Connection.class, Integer.class})})
public class PreventNoWhereConditionInterceptor
implements Interceptor {
    public Object intercept(Invocation invocation) throws Throwable {
        StatementHandler statementHandler = (StatementHandler)invocation.getTarget();
        BoundSql boundSql = statementHandler.getBoundSql();
        String sql = boundSql.getSql();
        if (sql.toUpperCase().contains("UPDATE") || sql.toUpperCase().contains("DELETE")) {
            if (!sql.toUpperCase().contains("WHERE")) {
                throw new RuntimeException("no valid where condition found for update or delete statement!:" + sql);
            }
            boolean hasWhereClause = sql.trim().toLowerCase().endsWith("WHERE 1=1");
            if (hasWhereClause) {
                throw new RuntimeException("where condition only found 1=1  for update or delete statement!:" + sql);
            }
            List parameterMappings = boundSql.getParameterMappings();
            if (parameterMappings.size() < 1) {
                hasWhereClause = true;
            }
            if (hasWhereClause) {
                throw new RuntimeException("Update or delete statement without WHERE condition is not allowed!:" + sql);
            }
        }
        return invocation.proceed();
    }

    public Object plugin(Object target) {
        return Plugin.wrap((Object)target, (Interceptor)this);
    }

    public void setProperties(Properties properties) {
    }
}

