/*
 * Decompiled with CFR 0.152.
 */
package com.ohaotian.plugin.db.impl;

import com.alibaba.druid.pool.DruidDataSource;
import com.alibaba.druid.pool.DruidPooledConnection;
import com.ohaotian.plugin.db.OrderSequence;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;

public class OrderSequenceImpl
implements OrderSequence {
    private String sequenceName;
    private DruidDataSource dataSource;
    private static final String QUERY_CURRENT_VALUE = "select current_value, step from ohaotian_order_sequence where name = ? for update";
    private static final String UPDATE_CURRENT_VALUE = "update ohaotian_order_sequence set current_value = current_value + step  where name = ?";
    private static final String UPDATE_BATCH_CURRENT_VALUE = "update ohaotian_order_sequence set current_value = current_value + (step * ?)  where name = ?";

    public OrderSequenceImpl(String sequenceName, DruidDataSource dataSource) {
        this.sequenceName = sequenceName;
        this.dataSource = dataSource;
    }

    @Override
    public long nextId() throws SQLException {
        long id;
        block25: {
            try (DruidPooledConnection conn = this.dataSource.getConnection();
                 PreparedStatement psUpdate = this.createUpdatePreparedStatement(conn);
                 PreparedStatement psQuery = this.createPreparedStatement(conn);){
                conn.setAutoCommit(false);
                psUpdate.execute();
                try (ResultSet rs = psQuery.executeQuery();){
                    if (rs.next()) {
                        id = rs.getLong("current_value");
                        conn.commit();
                        break block25;
                    }
                    throw new IllegalArgumentException("Can't find " + this.sequenceName + " from table ohaotian_order_sequence, please create sequence. ");
                }
            }
        }
        return id;
    }

    private PreparedStatement createUpdatePreparedStatement(DruidPooledConnection conn) throws SQLException {
        PreparedStatement ps = conn.prepareStatement(UPDATE_CURRENT_VALUE);
        ps.setString(1, this.sequenceName);
        return ps;
    }

    private PreparedStatement createPreparedStatement(DruidPooledConnection conn) throws SQLException {
        PreparedStatement ps = conn.prepareStatement(QUERY_CURRENT_VALUE);
        ps.setString(1, this.sequenceName);
        return ps;
    }

    @Override
    public long[] nextIds(int idNum) throws SQLException {
        long[] ids;
        block25: {
            try (DruidPooledConnection conn = this.dataSource.getConnection();
                 PreparedStatement psUpdate = this.createUpdateBatchPreparedStatement(conn, idNum);
                 PreparedStatement psQuery = this.createPreparedStatement(conn);){
                conn.setAutoCommit(false);
                psUpdate.execute();
                try (ResultSet rs = psQuery.executeQuery();){
                    if (rs.next()) {
                        long id = rs.getLong("current_value");
                        int step = rs.getInt("step");
                        ids = OrderSequenceImpl.batchIds(idNum, id, step);
                        conn.commit();
                        break block25;
                    }
                    throw new IllegalArgumentException("Can't find " + this.sequenceName + " from table ohaotian_order_sequence, please create sequence. ");
                }
            }
        }
        return ids;
    }

    private static long[] batchIds(int idNum, long id, int step) {
        long[] ids = new long[idNum];
        for (int i = idNum; i > 0; --i) {
            ids[i - 1] = id - (long)(step * (idNum - i));
        }
        return ids;
    }

    private PreparedStatement createUpdateBatchPreparedStatement(DruidPooledConnection conn, int idNum) throws SQLException {
        PreparedStatement ps = conn.prepareStatement(UPDATE_BATCH_CURRENT_VALUE);
        ps.setInt(1, idNum);
        ps.setString(2, this.sequenceName);
        return ps;
    }
}

