/*
 * Decompiled with CFR 0.152.
 */
package com.ohaotian.plugin.file.config;

import com.ohaotian.plugin.file.FileClient;
import com.ohaotian.plugin.file.oss.OssConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
public class PluginFileConfig {
    private static final Logger logger = LoggerFactory.getLogger(PluginFileConfig.class);
    @Value(value="${oss.endpoint}")
    private String endpoint;
    @Value(value="${oss.accesskey}")
    private String accesskey;
    @Value(value="${oss.accessKeySecret}")
    private String accessKeySecret;
    @Value(value="${oss.bucketName}")
    private String bucketName;
    @Value(value="${oss.accessUrl}")
    private String accessUrl;

    @Bean
    public OssConfig ossConfig() {
        logger.info("plugin-file:endpoint:{}, accesskey:{}, accessKeySecret:{}, bucketName:{}, accessUrl:{}", new Object[]{this.endpoint, this.accesskey, this.accessKeySecret, this.bucketName, this.accessUrl});
        OssConfig ossConfig = new OssConfig(this.endpoint, this.accesskey, this.accessKeySecret, this.bucketName, this.accessUrl);
        return ossConfig;
    }

    @Bean
    public FileClient fileClient() {
        FileClient fileClient = new FileClient();
        fileClient.setOssConfig(this.ossConfig());
        return fileClient;
    }
}

