/*
 * Decompiled with CFR 0.152.
 */
package com.ohaotian.plugin.file.ftp;

import com.ohaotian.plugin.file.AbstractFileClient;
import com.ohaotian.plugin.file.constant.FileType;
import com.ohaotian.plugin.file.ftp.FtpConfig;
import com.ohaotian.plugin.file.ftp.FtpUtil;
import java.io.File;
import java.io.InputStream;
import java.util.List;

public class FtpFileClient
extends AbstractFileClient {
    private FtpConfig ftpConfig;

    public FtpFileClient(FtpConfig ftpConfig) {
        this.ftpConfig = ftpConfig;
    }

    @Override
    public String uploadFileByInputStream(String uploadFilePath, String fileName, InputStream inputStream) {
        String filePath = this.getFilePath(uploadFilePath, fileName);
        FtpUtil.uploadFileByInputStream(fileName, this.ftpConfig, inputStream, uploadFilePath);
        return filePath;
    }

    @Override
    public File downloadToFile(String filePath) {
        return FtpUtil.downloadFile(filePath, this.ftpConfig);
    }

    @Override
    public InputStream downLoadToInputStream(String filePath) {
        return FtpUtil.downloadByInputStream(filePath, this.ftpConfig);
    }

    @Override
    public List<String> listFiles(String filePath, String suffix) {
        return FtpUtil.listFiles(filePath, suffix, this.ftpConfig);
    }

    @Override
    protected FileType getFileType() {
        return FileType.FTP;
    }
}

