/*
 * Decompiled with CFR 0.152.
 */
package com.ohaotian.plugin.file.oss;

import com.ohaotian.plugin.file.AbstractFileClient;
import com.ohaotian.plugin.file.constant.FileType;
import com.ohaotian.plugin.file.oss.OssConfig;
import com.ohaotian.plugin.file.oss.OssUtil;
import java.io.File;
import java.io.InputStream;
import java.util.List;

public class OssFileClient
extends AbstractFileClient {
    private OssConfig ossConfig;

    public OssFileClient(OssConfig ossConfig) {
        this.ossConfig = ossConfig;
    }

    @Override
    public String uploadFileByInputStream(String uploadFilePath, String fileName, InputStream inputStream) {
        String filePath = this.getFilePath(uploadFilePath, fileName);
        OssUtil.uploadFileToOssByInputStream(filePath, this.ossConfig, inputStream);
        return filePath;
    }

    @Override
    public File downloadToFile(String filePath) {
        return OssUtil.downloadFile(filePath, this.ossConfig);
    }

    @Override
    public InputStream downLoadToInputStream(String filePath) {
        return OssUtil.downloadByInputStream(filePath, this.ossConfig);
    }

    @Override
    public List<String> listObjects(String prefix) {
        return OssUtil.listObjects(this.ossConfig, prefix);
    }

    @Override
    protected FileType getFileType() {
        return FileType.OSS;
    }
}

