/*
 * Decompiled with CFR 0.152.
 */
package com.ohaotian.plugin.file;

import com.ohaotian.plugin.file.constant.FileType;
import com.ohaotian.plugin.file.ftp.FtpConfig;
import com.ohaotian.plugin.file.ftp.FtpUtil;
import com.ohaotian.plugin.file.oss.OssConfig;
import com.ohaotian.plugin.file.oss.OssUtil;
import java.io.File;
import java.io.InputStream;
import java.util.List;

public class FileClient {
    private FileType type;
    private OssConfig ossConfig;
    private FtpConfig ftpConfig;

    public OssConfig getOssConfig() {
        return this.ossConfig;
    }

    public void setOssConfig(OssConfig ossConfig) {
        this.ossConfig = ossConfig;
    }

    public String uploadFileByInputStream(String uploadFilePath, String fileName, InputStream inputStream) {
        if (!uploadFilePath.endsWith("/")) {
            uploadFilePath = uploadFilePath + "/";
        }
        String filePath = uploadFilePath + fileName;
        switch (this.type) {
            case OSS: {
                OssUtil.uploadFileToOssByInputStream(filePath, this.ossConfig, inputStream);
                break;
            }
            case FTP: {
                FtpUtil.uploadFileByInputStream(fileName, this.ftpConfig, inputStream, uploadFilePath);
                break;
            }
            default: {
                throw new IllegalArgumentException("plugin-file config error");
            }
        }
        return filePath;
    }

    public File downloadToFile(String filePath) {
        switch (this.type) {
            case OSS: {
                return OssUtil.downloadFile(filePath, this.ossConfig);
            }
            case FTP: {
                return FtpUtil.downloadFile(filePath, this.ftpConfig);
            }
        }
        throw new IllegalArgumentException("plugin-file config error");
    }

    public InputStream downLoadToInputStream(String filePath) {
        switch (this.type) {
            case OSS: {
                return OssUtil.downloadByInputStream(filePath, this.ossConfig);
            }
            case FTP: {
                return FtpUtil.downloadByInputStream(filePath, this.ftpConfig);
            }
        }
        throw new IllegalArgumentException("plugin-file config error");
    }

    public List<String> listObjects(String prefix) {
        switch (this.type) {
            case OSS: {
                return OssUtil.listObjects(this.ossConfig, prefix);
            }
            case FTP: {
                throw new IllegalArgumentException("FTP not support listObjects method");
            }
        }
        throw new IllegalArgumentException("plugin-file config error");
    }

    public List<String> listFiles(String filePath, String suffix) {
        switch (this.type) {
            case FTP: {
                return FtpUtil.listFiles(filePath, suffix, this.ftpConfig);
            }
            case OSS: {
                throw new IllegalArgumentException("OSS not support listFiles method");
            }
        }
        throw new IllegalArgumentException("plugin-file config error");
    }

    public void setFtpConfig(FtpConfig ftpConfig) {
        this.ftpConfig = ftpConfig;
    }

    public void setType(FileType type) {
        this.type = type;
    }
}

