/*
 * Decompiled with CFR 0.152.
 */
package com.ohaotian.plugin.file.config;

import com.ohaotian.plugin.file.FileClient;
import com.ohaotian.plugin.file.constant.FileType;
import com.ohaotian.plugin.file.ftp.FtpConfig;
import com.ohaotian.plugin.file.oss.OssConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
public class PluginFileConfig {
    private static final Logger logger = LoggerFactory.getLogger(PluginFileConfig.class);
    @Value(value="${oss.endpoint:}")
    private String endpoint;
    @Value(value="${oss.accesskey:}")
    private String accesskey;
    @Value(value="${oss.accessKeySecret:}")
    private String accessKeySecret;
    @Value(value="${oss.bucketName:}")
    private String bucketName;
    @Value(value="${oss.accessUrl:}")
    private String accessUrl;
    @Value(value="${ftp.host:}")
    private String ftpHost;
    @Value(value="${ftp.user:}")
    private String ftpUser;
    @Value(value="${ftp.pwd:}")
    private String ftpPwd;
    @Value(value="${ftp.port:}")
    private Integer ftpPort;
    @Value(value="${ftp.timeout:}")
    private Integer ftpTimeout;

    @Bean
    public OssConfig ossConfig() {
        logger.info("plugin-file:endpoint:{}, accesskey:{}, accessKeySecret:{}, bucketName:{}, accessUrl:{}", new Object[]{this.endpoint, this.accesskey, this.accessKeySecret, this.bucketName, this.accessUrl});
        OssConfig ossConfig = new OssConfig(this.endpoint, this.accesskey, this.accessKeySecret, this.bucketName, this.accessUrl);
        return ossConfig;
    }

    @Bean
    public FtpConfig ftpConfig() {
        logger.info("plugin-file:ftpHost:{}, ftpUser:{}, ftpPwd:{}, ftpPort:{}, ftpTimeout:{}", new Object[]{this.ftpHost, this.ftpUser, this.ftpPwd, this.ftpPort, this.ftpTimeout});
        FtpConfig ftpConfig = new FtpConfig(this.ftpHost, this.ftpUser, this.ftpPwd, this.ftpPort, this.ftpTimeout);
        return ftpConfig;
    }

    @Bean
    public FileClient fileClient() {
        FileClient fileClient = new FileClient();
        fileClient.setFtpConfig(this.ftpConfig());
        boolean ossOk = this.ossConfig().check();
        boolean ftpOk = this.ftpConfig().check();
        if (ossOk) {
            fileClient.setType(FileType.OSS);
            fileClient.setOssConfig(this.ossConfig());
        } else if (ftpOk) {
            fileClient.setType(FileType.FTP);
            fileClient.setFtpConfig(this.ftpConfig());
        } else {
            logger.error("\u6587\u4ef6\u4e0a\u4f20\u5c5e\u6027\u914d\u7f6e\u9519\u8bef\uff0c\u8bf7\u68c0\u67e5\u914d\u7f6e\u6587\u4ef6");
        }
        return fileClient;
    }
}

