/*
 * Decompiled with CFR 0.152.
 */
package com.ohaotian.plugin.file.ftp;

import com.jcraft.jsch.ChannelSftp;
import com.jcraft.jsch.Session;
import com.jcraft.jsch.SftpException;
import com.ohaotian.plugin.base.exception.ResourceException;
import com.ohaotian.plugin.file.ftp.FtpConfig;
import com.ohaotian.plugin.file.util.SessionChannelUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import java.util.Vector;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FtpUtil {
    private static final Logger log = LoggerFactory.getLogger(FtpUtil.class);

    public static void uploadFile(File file, FtpConfig ftp, String uploadPath) {
        String fileName;
        String newFileName = fileName = file.getName();
        FileInputStream fis = null;
        SessionChannelUtil scu = null;
        ChannelSftp channelSftp = null;
        try {
            scu = new SessionChannelUtil();
            fis = new FileInputStream(file);
            Session session = scu.sessionConnect(ftp.getFileUser(), ftp.getFileHost(), ftp.getFilePort(), ftp.getFilePwd(), ftp.getTimeOut());
            channelSftp = scu.channelSftpConnect(session, ftp.getTimeOut());
            try {
                Vector content = channelSftp.ls(uploadPath);
                if (content == null) {
                    channelSftp.mkdir(uploadPath);
                }
            }
            catch (SftpException e) {
                channelSftp.mkdir(uploadPath);
            }
            channelSftp.put((InputStream)fis, uploadPath + newFileName + ".tmp", 0);
            try {
                channelSftp.rename(uploadPath + newFileName + ".tmp", uploadPath + newFileName);
            }
            catch (Exception e) {
                channelSftp.rm(uploadPath + newFileName);
                channelSftp.rename(uploadPath + newFileName + ".tmp", uploadPath + newFileName);
            }
        }
        catch (Exception e) {
            log.error("\u8fde\u63a5\u8fdc\u7a0b\u670d\u52a1\u5668\u51fa\u9519\uff01\u8bf7\u68c0\u67e5\u4e3b\u673a\u914d\u7f6e\u3010host:" + ftp.getFileHost() + ",\u7528\u6237\u540d:" + ftp.getFileUser() + ",\u7aef\u53e3:" + ftp.getFilePort() + "\u3011\u540c\u65f6\u68c0\u67e5\u8def\u5f84\u3010" + uploadPath + "\u662f\u5426\u6709\u6743\u9650\u3011", (Throwable)e);
            throw new ResourceException("F007", "\u8fde\u63a5\u8fdc\u7a0b\u670d\u52a1\u5668\u51fa\u9519\uff01\u8bf7\u68c0\u67e5\u4e3b\u673a\u914d\u7f6e\u3010host:" + ftp.getFileHost() + ",\u7528\u6237\u540d:" + ftp.getFileUser() + ",\u7aef\u53e3:" + ftp.getFilePort() + "\u3011\u540c\u65f6\u68c0\u67e5\u6587\u4ef6\u8def\u5f84\u3010" + uploadPath + "\u662f\u5426\u6709\u6743\u9650\u3011", (Throwable)e);
        }
        finally {
            if (scu != null) {
                try {
                    scu.closeSession();
                    ((InputStream)fis).close();
                }
                catch (Exception e) {
                    log.error("\u5173\u95ed\u8fdc\u7a0b\u8fde\u63a5\u51fa\u9519\uff01\u8bf7\u68c0\u67e5\u4e3b\u673a\u914d\u7f6e\u3010host:" + ftp.getFileHost() + ",\u7528\u6237\u540d:" + ftp.getFileUser() + ",\u7aef\u53e3:" + ftp.getFilePort() + "\u3011", (Throwable)e);
                    throw new ResourceException("F007", "\u8fde\u63a5\u8fdc\u7a0b\u670d\u52a1\u5668\u51fa\u9519\uff01\u8bf7\u68c0\u67e5\u4e3b\u673a\u914d\u7f6e\u3010host:" + ftp.getFileHost() + ",\u7528\u6237\u540d:" + ftp.getFileUser() + ",\u7aef\u53e3:" + ftp.getFilePort() + "\u3011\u540c\u65f6\u68c0\u67e5\u6587\u4ef6\u8def\u5f84\u3010" + uploadPath + "\u662f\u5426\u6709\u6743\u9650\u3011", (Throwable)e);
                }
            }
        }
    }

    public static void uploadFileByInputStream(String fileName, FtpConfig ftp, InputStream fis, String uploadPath) {
        String newFileName = fileName;
        SessionChannelUtil scu = null;
        ChannelSftp channelSftp = null;
        try {
            scu = new SessionChannelUtil();
            Session session = scu.sessionConnect(ftp.getFileUser(), ftp.getFileHost(), ftp.getFilePort(), ftp.getFilePwd(), ftp.getTimeOut());
            channelSftp = scu.channelSftpConnect(session, ftp.getTimeOut());
            try {
                Vector content = channelSftp.ls(uploadPath);
                if (content == null) {
                    channelSftp.mkdir(uploadPath);
                }
            }
            catch (SftpException e) {
                channelSftp.mkdir(uploadPath);
            }
            channelSftp.put(fis, uploadPath + newFileName + ".tmp", 0);
            channelSftp.rename(uploadPath + newFileName + ".tmp", uploadPath + newFileName);
        }
        catch (Exception e) {
            log.error("\u8fde\u63a5\u8fdc\u7a0b\u670d\u52a1\u5668\u51fa\u9519\uff01\u8bf7\u68c0\u67e5\u4e3b\u673a\u914d\u7f6e\u3010host:" + ftp.getFileHost() + ",\u7528\u6237\u540d:" + ftp.getFileUser() + ",\u7aef\u53e3:" + ftp.getFilePort() + "\u3011\u540c\u65f6\u68c0\u67e5\u8def\u5f84\u3010" + uploadPath + "\u662f\u5426\u6709\u6743\u9650\u3011", (Throwable)e);
            throw new ResourceException("F007", "\u8fde\u63a5\u8fdc\u7a0b\u670d\u52a1\u5668\u51fa\u9519\uff01\u8bf7\u68c0\u67e5\u4e3b\u673a\u914d\u7f6e\u3010host:" + ftp.getFileHost() + ",\u7528\u6237\u540d:" + ftp.getFileUser() + ",\u7aef\u53e3:" + ftp.getFilePort() + "\u3011\u540c\u65f6\u68c0\u67e5\u6587\u4ef6\u8def\u5f84\u3010" + uploadPath + "\u662f\u5426\u6709\u6743\u9650\u3011", (Throwable)e);
        }
        finally {
            if (scu != null) {
                try {
                    scu.closeSession();
                }
                catch (Exception e) {
                    log.error("\u5173\u95ed\u8fdc\u7a0b\u8fde\u63a5\u51fa\u9519\uff01\u8bf7\u68c0\u67e5\u4e3b\u673a\u914d\u7f6e\u3010host:" + ftp.getFileHost() + ",\u7528\u6237\u540d:" + ftp.getFileUser() + ",\u7aef\u53e3:" + ftp.getFilePort() + "\u3011", (Throwable)e);
                    throw new ResourceException("F007", "\u8fde\u63a5\u8fdc\u7a0b\u670d\u52a1\u5668\u51fa\u9519\uff01\u8bf7\u68c0\u67e5\u4e3b\u673a\u914d\u7f6e\u3010host:" + ftp.getFileHost() + ",\u7528\u6237\u540d:" + ftp.getFileUser() + ",\u7aef\u53e3:" + ftp.getFilePort() + "\u3011\u540c\u65f6\u68c0\u67e5\u6587\u4ef6\u8def\u5f84\u3010" + uploadPath + "\u662f\u5426\u6709\u6743\u9650\u3011", (Throwable)e);
                }
            }
        }
    }

    public static File downloadFile(String filePath, FtpConfig ftp) {
        SessionChannelUtil scu = new SessionChannelUtil();
        Session session = null;
        String fileName = UUID.randomUUID() + filePath.substring(filePath.lastIndexOf("."), filePath.length());
        try {
            session = scu.sessionConnect(ftp.getFileUser(), ftp.getFileHost(), ftp.getFilePort(), ftp.getFilePwd(), ftp.getTimeOut());
            ChannelSftp channelSftp = scu.channelSftpConnect(session, ftp.getTimeOut());
            String dir = System.getProperty("java.io.tmpdir");
            File dirFile = new File(dir);
            if (!dirFile.exists()) {
                dirFile.mkdirs();
            }
            fileName = dir + File.separator + fileName;
            channelSftp.get(filePath, fileName);
            log.debug("FileName:" + fileName);
        }
        catch (SftpException e) {
            throw new ResourceException("F007", "\u6587\u4ef6\u4e0d\u5b58\u5728\uff01");
        }
        catch (Exception e) {
            log.error("\u8fde\u63a5\u8fdc\u7a0b\u670d\u52a1\u5668\u51fa\u9519\uff01\u8bf7\u68c0\u67e5\u4e3b\u673a\u914d\u7f6e\u3010host:" + ftp.getFileHost() + ",\u7528\u6237\u540d:" + ftp.getFileUser() + ",\u7aef\u53e3:" + ftp.getFilePort() + "\u3011\u540c\u65f6\u68c0\u67e5\u6587\u4ef6\u3010" + filePath + "\u662f\u5426\u5b58\u5728\u3011", (Throwable)e);
            throw new ResourceException("F007", "\u8fde\u63a5\u8fdc\u7a0b\u670d\u52a1\u5668\u51fa\u9519\uff01\u8bf7\u68c0\u67e5\u4e3b\u673a\u914d\u7f6e\u3010host:" + ftp.getFileHost() + ",\u7528\u6237\u540d:" + ftp.getFileUser() + ",\u7aef\u53e3:" + ftp.getFilePort() + "\u3011", (Throwable)e);
        }
        finally {
            try {
                scu.closeSession();
            }
            catch (Exception e) {
                log.error("\u5173\u95ed\u8fdc\u7a0b\u8fde\u63a5\u51fa\u9519\uff01\u8bf7\u68c0\u67e5\u4e3b\u673a\u914d\u7f6e\u3010host:" + ftp.getFileHost() + ",\u7528\u6237\u540d:" + ftp.getFileUser() + ",\u7aef\u53e3:" + ftp.getFilePort() + "\u3011", (Throwable)e);
                throw new ResourceException("F007", "\u8fde\u63a5\u8fdc\u7a0b\u670d\u52a1\u5668\u51fa\u9519\uff01\u8bf7\u68c0\u67e5\u4e3b\u673a\u914d\u7f6e\u3010host:" + ftp.getFileHost() + ",\u7528\u6237\u540d:" + ftp.getFileUser() + ",\u7aef\u53e3:" + ftp.getFilePort() + "\u3011", (Throwable)e);
            }
        }
        return new File(fileName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<String> listFiles(String filePath, String suffix, FtpConfig ftp) {
        SessionChannelUtil scu = new SessionChannelUtil();
        Session session = null;
        Vector files = null;
        ArrayList<String> fileList = new ArrayList<String>();
        try {
            session = scu.sessionConnect(ftp.getFileUser(), ftp.getFileHost(), ftp.getFilePort(), ftp.getFilePwd(), ftp.getTimeOut());
            ChannelSftp channelSftp = scu.channelSftpConnect(session, ftp.getTimeOut());
            files = channelSftp.ls(filePath);
            for (Object object : files) {
                String curStr = object.toString();
                if (!(curStr = curStr.substring(curStr.lastIndexOf(" ") + 1)).contains(suffix)) continue;
                fileList.add(curStr);
            }
        }
        catch (Exception e) {
            log.error("\u8fde\u63a5\u8fdc\u7a0b\u670d\u52a1\u5668\u51fa\u9519\uff01\u8bf7\u68c0\u67e5\u4e3b\u673a\u914d\u7f6e\u3010host:" + ftp.getFileHost() + ",\u7528\u6237\u540d:" + ftp.getFileUser() + ",\u7aef\u53e3:" + ftp.getFilePort() + "\u3011\u540c\u65f6\u68c0\u67e5\u6587\u4ef6\u8def\u5f84\u3010" + filePath + "\u662f\u5426\u5b58\u5728\u3011", (Throwable)e);
        }
        finally {
            try {
                scu.closeSession();
            }
            catch (Exception e) {
                log.error("\u5173\u95ed\u8fdc\u7a0b\u8fde\u63a5\u51fa\u9519\uff01\u8bf7\u68c0\u67e5\u4e3b\u673a\u914d\u7f6e\u3010host:" + ftp.getFileHost() + ",\u7528\u6237\u540d:" + ftp.getFileUser() + ",\u7aef\u53e3:" + ftp.getFilePort() + "\u3011", (Throwable)e);
            }
        }
        return fileList;
    }

    public static void deleteFile(String filePath, FtpConfig ftp) {
        SessionChannelUtil scu = new SessionChannelUtil();
        Session session = null;
        try {
            session = scu.sessionConnect(ftp.getFileUser(), ftp.getFileHost(), ftp.getFilePort(), ftp.getFilePwd(), ftp.getTimeOut());
            ChannelSftp channelSftp = scu.channelSftpConnect(session, ftp.getTimeOut());
            channelSftp.rm(filePath);
        }
        catch (Exception e) {
            log.error("\u8fde\u63a5\u8fdc\u7a0b\u670d\u52a1\u5668\u51fa\u9519\uff01\u8bf7\u68c0\u67e5\u4e3b\u673a\u914d\u7f6e\u3010host:" + ftp.getFileHost() + ",\u7528\u6237\u540d:" + ftp.getFileUser() + ",\u7aef\u53e3:" + ftp.getFilePort() + "\u3011\u540c\u65f6\u68c0\u67e5\u6587\u4ef6\u8def\u5f84\u3010" + filePath + "\u662f\u5426\u5b58\u5728\u3011", (Throwable)e);
            throw new ResourceException("F007", "\u8fde\u63a5\u8fdc\u7a0b\u670d\u52a1\u5668\u51fa\u9519\uff01\u8bf7\u68c0\u67e5\u4e3b\u673a\u914d\u7f6e\u3010host:" + ftp.getFileHost() + ",\u7528\u6237\u540d:" + ftp.getFileUser() + ",\u7aef\u53e3:" + ftp.getFilePort() + "\u3011", (Throwable)e);
        }
        finally {
            try {
                scu.closeSession();
            }
            catch (Exception e) {
                log.error("\u5173\u95ed\u8fdc\u7a0b\u8fde\u63a5\u51fa\u9519\uff01\u8bf7\u68c0\u67e5\u4e3b\u673a\u914d\u7f6e\u3010host:" + ftp.getFileHost() + ",\u7528\u6237\u540d:" + ftp.getFileUser() + ",\u7aef\u53e3:" + ftp.getFilePort() + "\u3011", (Throwable)e);
                throw new ResourceException("F007", "\u8fde\u63a5\u8fdc\u7a0b\u670d\u52a1\u5668\u51fa\u9519\uff01\u8bf7\u68c0\u67e5\u4e3b\u673a\u914d\u7f6e\u3010host:" + ftp.getFileHost() + ",\u7528\u6237\u540d:" + ftp.getFileUser() + ",\u7aef\u53e3:" + ftp.getFilePort() + "\u3011", (Throwable)e);
            }
        }
    }

    public static InputStream downloadByInputStream(String filePath, FtpConfig ftpConfig) {
        try {
            return new FileInputStream(FtpUtil.downloadFile(filePath, ftpConfig));
        }
        catch (FileNotFoundException e) {
            log.error(e.getMessage(), (Throwable)e);
            return null;
        }
    }
}

