package com.ohaotian.plugin.file;

import java.io.File;
import java.io.InputStream;
import java.util.List;

/**
 * 标题：文件插件核心接口
 * <p>
 * 说明：文件插件核心接口
 * <br>
 * 时间：2018/07/09<br>
 * 版权：copyright © 2018 www.tydic.com Inc. All rights reserved.
 * </p>
 *
 * @author ZhangCheng
 */
public interface FileClient {

    /**
     * 上传文件通过输入流
     * @param uploadFilePath 文件路径
     * @param fileName 文件名称
     * @param inputStream 输入流
     * @return 文件路径及名称
     */
    String uploadFileByInputStream(String uploadFilePath, String fileName, InputStream inputStream);

    /**
     * 下载为文件通过文件路径及名称
     * @param filePath 文件路径及名称
     * @return 文件
     */
    File downloadToFile(String filePath);

    /**
     * 下载为输入流通过文件路径及名称
     * @param filePath 文件路径及名称
     * @return 输入流
     */
    InputStream downLoadToInputStream(String filePath);

    /**
     * 返回指定前缀的文件名称列表
     *
     * @param prefix 参数prefix是指定返回Object的前缀
     * @return 最多返回100条object名称
     */
    List<String> listObjects(String prefix);

    /**
     * 返回指定后缀的文件名称列表
     * @param filePath 文件路径及名称
     * @param suffix 后缀
     * @return 最多返回100条object名称
     */
    List<String> listFiles(String filePath, String suffix);
}
