package com.ohaotian.plugin.file;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.util.Calendar;
import java.util.List;
import java.util.Properties;
import java.util.UUID;

import com.ohaotian.plugin.file.constant.TempFileConstant;
import org.apache.commons.lang3.time.DateFormatUtils;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import com.ohaotian.plugin.file.ftp.FtpConfig;
import com.ohaotian.plugin.file.ftp.FtpUtil;
import com.ohaotian.plugin.file.oss.OssConfig;
import com.ohaotian.plugin.file.oss.OssUtil;

/** <br>
 * 标题: 文件处理类<br>
 * 描述: <br>
 *
 * @autho liuce zhenweishan
 * @time 2016年9月22日 上午12:01:10 */
public class FileProcessing {

    private static final Logger log       = LoggerFactory.getLogger(FileProcessing.class);

    /** 配置文件 */
    private static Properties   prop;

    /** 主机地址 */
    public static String        fileHost;

    /** 主机密码 */
    public static String        fileUser;

    /** 主机密码 */
    public static String        filePwd;

    /** 端口 */
    public static Integer       filePort;

    /** 连接超时时间 */
    public static Integer       timeOut;

    /** 内部ftp服务器跟路径 */
    public static String        sysFtpRootPath;

    /** oss域名 */
    private static String       endpoint;
    /** accessKey */
    private static String       accessKeyId;
    /** accessKeySecret */
    private static String       accessKeySecret;

    /** bucketName oss存储空间 */
    private static String       bucketName;

    /** 允许访问的地址 */
    private static String       accessUrl;

    /** 是否开启本地模式 */
    private static boolean      nativeOSS = false;

    /** ftp配置 */
    private static FtpConfig    ftpConfig;

    /** oss配置 */
    private static OssConfig    ossConfig;

    /** 针对能力平台的上传地址 */
    public static String        esbFtpUpload;

    /** 针对能力平台的下载地址 */
    public static String        esbFtpDowload;

    /** oss文件的根路径 */
    public static String        ossBasePath;

    public static OssConfig getOssConfig(){
        return FileProcessing.ossConfig;
    }
    /** 设置 配置文件
     *
     * @param prop
     *        配置文件 */
    public void setProp(Properties prop) {
        FileProcessing.prop = prop;

        fileHost = FileProcessing.prop.getProperty(TempFileConstant.FILE_HOST).trim();

        fileUser = FileProcessing.prop.getProperty(TempFileConstant.FILE_USER).trim();

        filePwd = FileProcessing.prop.getProperty(TempFileConstant.FILE_PWD).trim();

        filePort = Integer.parseInt(FileProcessing.prop.getProperty(TempFileConstant.FILE_PORT).trim());

        timeOut = Integer.parseInt(FileProcessing.prop.getProperty(TempFileConstant.TIME_OUT).trim());

        sysFtpRootPath = FileProcessing.prop.getProperty(TempFileConstant.FILE_UPLOAD_PATH).trim();

        endpoint = FileProcessing.prop.getProperty(TempFileConstant.OSS_ENDPOINT, "").trim();

        accessKeyId = FileProcessing.prop.getProperty(TempFileConstant.OSS_ACCESSKEY, "").trim();

        accessKeySecret = FileProcessing.prop.getProperty(TempFileConstant.OSS_ACCESSKEY_SECRET, "").trim();

        nativeOSS = Boolean.parseBoolean(FileProcessing.prop.getProperty(TempFileConstant.OSS_NATIVE, "false"));

        bucketName = FileProcessing.prop.getProperty(TempFileConstant.OSS_BUCKETNAME, "").trim();

        accessUrl = FileProcessing.prop.getProperty(TempFileConstant.OSS_ACCESS_URL, "").trim();

        ossBasePath = FileProcessing.prop.getProperty(TempFileConstant.OSS_BASE_PATH, "").trim();

        //if (nativeOSS) {
        ossConfig = new OssConfig(endpoint, accessKeyId, accessKeySecret, bucketName, accessUrl);
        //}

        ftpConfig = new FtpConfig(fileHost, fileUser, filePwd, filePort, timeOut);

        esbFtpUpload = FileProcessing.prop.getProperty(TempFileConstant.ESB_FTP_UPLOAD).trim();

        esbFtpDowload = FileProcessing.prop.getProperty(TempFileConstant.ESB_FTP_DOWLOAD).trim();

    }

    /** 内部系统文件下载<br>
     * 适用场景: 内部系统文件下载<br>
     * 调用方式: <br>
     * 业务逻辑说明<br>
     *
     * @autho liuce
     * @time 2016年9月21日 上午11:38:20 */
    public static File downloadFile(String fileName, String sysCenter, String businessType) {
        File file = null;
        if (nativeOSS) {
            file = OssUtil.downloadFile(getSysFileServicePath(sysCenter, businessType) + fileName, ossConfig);
        }
        else {
            file = FtpUtil.downloadFile(getSysFileServicePath(sysCenter, businessType) + fileName, ftpConfig);
        }
        return file;
    }


    /** 从esb上下载文件<br>
     * 适用场景: <br>
     * 调用方式: <br>
     * 业务逻辑说明<br>
     *
     * @return
     * @autho liuce
     * @time 2016年10月27日 上午11:18:10 */
    public static File downLoadFileFromEsb(String fileName) {
        return FtpUtil.downloadFile(esbFtpDowload + fileName, ftpConfig);
    }




    /**
    * 下载路径和上传路径一致ossBasePath
    *
    * */
    public static File downloadFileFromOss(String fileName) {
        String filePath=ossBasePath+"/"+fileName;
        File file = OssUtil.downloadFile(filePath, ossConfig);
        return file;
    }

    public static InputStream downloadInputStreamFromOss(String fileName) {
        return OssUtil.downloadByInputStream(fileName, ossConfig);
    }




    /** <br>
     * 适用场景: 获取内部文件系统的路径<br>
     * 调用方式: <br>
     * 业务逻辑说明<br>
     *
     * @param sysCenter
     * @param businessType
     * @return
     * @autho liuce
     * @time 2016年10月27日 上午10:42:15 */
    private static String getSysFileServicePath(String sysCenter, String businessType) {
        // OSS方式上传
        String filePath = null;
        if (TempFileConstant.CARD_CENTER.equals(sysCenter)) {
            // filePath = FileProcessing.prop.getProperty(TempFileConstant.OSS_FILE_CARD_PATH + businessType).trim();
            // TODO 目前先不根据业务类型来统一放到一个路劲
            filePath = FileProcessing.prop.getProperty(TempFileConstant.FILE_UPLOAD_PATH).trim();
            if (!nativeOSS) {
                // filePath = sysFtpRootPath + filePath;
            }
            else {
                filePath = filePath.substring(1);
            }
        }
        else if (TempFileConstant.NUM_CENTER.equals(sysCenter)) {
            // filePath = FileProcessing.prop.getProperty(TempFileConstant.OSS_FILE_NUM_PATH + businessType).trim();
            // TODO 目前先不根据业务类型来统一放到一个路劲
            filePath = FileProcessing.prop.getProperty(TempFileConstant.FILE_UPLOAD_PATH).trim();
            if (!nativeOSS) {
                // filePath = sysFtpRootPath + filePath;
            }
            else {
                filePath = filePath.substring(1);
            }
        }
        else {
            filePath = FileProcessing.prop.getProperty(TempFileConstant.FILE_UPLOAD_PATH).trim();
            if (!nativeOSS) {
                // filePath = sysFtpRootPath + filePath;
            }
            else {
                filePath = filePath.substring(1);
            }
        }
        return filePath;
    }

    /** <br>
     * 适用场景: 上传到内部文件系统<br>
     * 调用方式: <br>
     * 业务逻辑说明<br>
     *
     * @param file
     * @param businessType
     *        动作类型(key)
     * @param sysCenter
     *        (num号中心，card卡中心)
     * @param isNeedNewName
     *        是否需要改变名称
     * @return 文件名称
     * @throws Exception
     * @autho wesley
     * @time 2016年10月20日 下午3:02:36 */
    public static String upLoadFile(File file, String businessType, String sysCenter, boolean isNeedNewName) {

        String fileName = file.getName();
        if (isNeedNewName) {

            fileName = UUID.randomUUID() + fileName.substring(fileName.lastIndexOf("."), fileName.length());
        }
        if (nativeOSS) {
            // OSS方式上传
            OssUtil.uploadFile(file, ossConfig, getSysFileServicePath(sysCenter, businessType));
        }
        else {
            // Ftp方式上传
            FtpUtil.uploadFile(file, ftpConfig, getSysFileServicePath(sysCenter, businessType));
        }

        return fileName;

    }


    /** <br>
     * 适用场景: 流式上传本地文件到OSS<br>
     * 调用方式: <br>
     * 业务逻辑说明<br>
     *
     * @param localFilePath 本地文件位置
     * @param uploadPath 文件在oss存储的位置
     * @return
     * @autho zhangej
     * @time 2018年1月20日*/
    public static String uploadFileToOss(String localFilePath,String uploadPath) {
        File file=new File(localFilePath);
        //getSysFileServicePath(sysCenter, businessType)
        OssUtil.uploadFile(file, ossConfig,uploadPath);
        return "";
    }
    /** <br>
     * 适用场景: <br>
     * 调用方式: <br>
     * 业务逻辑说明<br>
     *
     * @param fileName
     * @param inputStream
     * @return
     * @autho liuce
     * @time 2017年7月2日 下午5:21:13 */
    public static String uploadFileToOSSByInputStream(String fileName, InputStream inputStream, String qserviceId) {
        // OSS方式上传
        Calendar cal = Calendar.getInstance();
        String currentDate = DateFormatUtils.format(cal, "yyyyMMdd");
        // String filePath = ossBasePath + "/permanent/" + qserviceId + "/" + currentDate + "/" + fileName;
        String filePath = ossBasePath + "/" + fileName;
        OssUtil.uploadFileToOssByInputStream(filePath, ossConfig, inputStream);
        return filePath;
    }




    /** 从ftp服务器上获取指定文件夹下的的指定规则的所有文件名<br>
     * 适用场景: <br>
     * 调用方式: <br>
     * 业务逻辑说明<br>
     *
     * @param suffix
     * @return
     * @autho liuce
     * @time 2016年10月27日 上午11:25:16 */
    public static List<String> listFiles(String suffix) {
        return FtpUtil.listFiles(esbFtpDowload, suffix, ftpConfig);
    }



    public static String uploadFileByInputStream(String fileName, InputStream inputStream, String businessType, String sysCenter, boolean isNeedNewName) {
        if (isNeedNewName) {

            fileName = UUID.randomUUID() + fileName.substring(fileName.lastIndexOf("."), fileName.length());
        }
        if (nativeOSS) {
            // OSS方式上传
            OssUtil.uploadFileByInputStream(fileName, ossConfig, inputStream, getSysFileServicePath(sysCenter, businessType));
        }
        else {
            // Ftp方式上传
            FtpUtil.uploadFileByInputStream(fileName, ftpConfig, inputStream, getSysFileServicePath(sysCenter, businessType));
        }
        return fileName;
    }


    /** 通过流式上传<br>
     * 适用场景: <br>
     * 调用方式: <br>
     * 业务逻辑说明<br>
     *
     * @param fileName
     * @param inputStream
     * @autho zhangej
     * @time 2018年1月22日 */
    public static void uploadFileByInputStream(String fileName, InputStream inputStream) {
        try{
            FtpUtil.uploadFileByInputStream(fileName, ftpConfig, inputStream, esbFtpUpload);
        } catch (Exception e) {
            e.printStackTrace();
        }

    }

    /** 将文件输入流 追加写入临时文件
     *
     * @param file
     * @param is
     * @throws Exception */
    public static void mergeFile(File file, InputStream is) throws Exception {
        log.debug("-----mergeFile start -----");
        BufferedOutputStream bos = null;
        try {
            bos = new BufferedOutputStream(new FileOutputStream(file, true));
            byte[] buf = new byte[1024];
            int len = 0;
            while ((len = is.read(buf)) != -1) {
                bos.write(buf, 0, len);
            }
            bos.flush();
            log.debug("-----mergeFile success -----");
        }
        catch (Exception e) {
            log.error("写入临时文件错误", e);
            throw new Exception("写入临时文件错误", e);
        }
        finally {
            if (bos != null) {
                bos.close();
            }
        }
        log.debug("-----mergeFile end -----");
    }

    /** 删除内部文件系统的指定文件<br>
     * 适用场景: <br>
     * 调用方式: <br>
     * 业务逻辑说明<br>
     *
     * @param fileName
     * @autho liuce
     * @time 2016年10月27日 上午11:26:43 */
    public static void deleteFile(String fileName, String sysCenter, String businessType) {
        if (nativeOSS) {
            OssUtil.deleteFile(getSysFileServicePath(sysCenter, businessType), ossConfig);
        }
        else {
            FtpUtil.deleteFile(getSysFileServicePath(sysCenter, businessType), ftpConfig);
        }
    }

    public static void main(String[] args) {

        // File file = new File("E:\\filetest\\test.xlsx");

        // System.out.println(upLoadFileByFtp(file));

        // System.out.println(downloadFile("/root/temp/040cde2e-ed75-49dd-9352-eb89c893aa44.xlsx"));
        // InputStream ips1 = Object.class.getClassLoader().getResourceAsStream("src/main/resources.properties");
        // System.out.println(ips1);
        // fileHost = "123.56.233.15";
        // fileUser = "root";
        // filePwd = "jkl;'iop[]";
        // filePort = 22;
        // timeOut = 1000;
        // deleteFile("/root/upload/61d8f322-92ae-4187-bc46-aa39600c067c.txt");
        // listFiles("/root/upload/",".txt");
        // File file = new File("E:\\filetest\\test.txt");
        // OssConfig ossConfig = new OssConfig("http://oss-cn-shanghai.aliyuncs.com", "LTAI3f0a7Nn4sPLD", "GqksQ1xEgGMH6zBo8Bh5PVbkCKBVK1","num-card");
        // ossConfig.setOssFilePath("input/internal/num/good/");
        // OssUtil.uploadFile(file, ossConfig);
        // OssUtil.deleteFile("61c0b3f0-2a6d-4830-a91c-4d6c8b52f041.txt", ossConfig);

        // /home/admin/taobao-tomcat-production-7.0.59.3/deploy/num_portal_web/WEB-INF/lib
        // File file = new File("E:\\filetest\\test.xlsx");
        // fileHost = "10.244.0.164";
        // fileUser = "frmc";
        // filePwd = "Prodfrmc";
        // filePort = 22;
        // timeOut = 1000;
        // sysFtpRootPath = "/resfile/";
        // upLoadFileByFtp(file);
    }
}
