package com.ohaotian.plugin.file.oss;

import org.apache.commons.lang3.StringUtils;

import static org.apache.commons.lang3.StringUtils.isNotBlank;

/** <br>
 * 标题: oss配置实体类<br>
 * 描述: <br>
 * 公司: www.tydic.com<br>
 *
 * @autho wesley
 * @time 2016年10月14日 下午6:05:33 */
public class OssConfig {

    /** oss域名 */
    private String endpoint;

    /** accessKey */
    private String accessKeyId;

    /** accessKeySecret */
    private String accessKeySecret;

    /** accessUrl允许访问的url */
    private String accessUrl;

    /** bucketName */
    private String bucketName;

    public OssConfig() {
        super();
    }

    public OssConfig(String endpoint, String accessKeyId, String accessKeySecret) {
        super();
        this.endpoint = endpoint;
        this.accessKeyId = accessKeyId;
        this.accessKeySecret = accessKeySecret;
    }

    public OssConfig(String endpoint, String accessKeyId, String accessKeySecret, String bucketName) {
        super();
        this.endpoint = endpoint;
        this.accessKeyId = accessKeyId;
        this.accessKeySecret = accessKeySecret;
        this.bucketName = bucketName;
    }

    public OssConfig(String endpoint, String accessKeyId, String accessKeySecret, String bucketName, String accessUrl) {
        super();
        this.endpoint = endpoint;
        this.accessKeyId = accessKeyId;
        this.accessKeySecret = accessKeySecret;
        this.accessUrl = accessUrl;
        this.bucketName = bucketName;
    }

    /** 返回 oss域名
     *
     * @return oss域名 */
    public String getEndpoint() {
        return endpoint;
    }

    /** 设置 oss域名
     *
     * @param endpoint
     *        oss域名 */
    public void setEndpoint(String endpoint) {
        this.endpoint = endpoint;
    }

    /** 返回 accessKey
     *
     * @return accessKey */
    public String getAccessKeyId() {
        return accessKeyId;
    }

    /** 设置 accessKey
     *
     * @param accessKeyId
     *        accessKey */
    public void setAccessKeyId(String accessKeyId) {
        this.accessKeyId = accessKeyId;
    }

    /** 返回 accessKeySecret
     *
     * @return accessKeySecret */
    public String getAccessKeySecret() {
        return accessKeySecret;
    }

    /** 设置 accessKeySecret
     *
     * @param accessKeySecret
     *        accessKeySecret */
    public void setAccessKeySecret(String accessKeySecret) {
        this.accessKeySecret = accessKeySecret;
    }

    /** 返回 bucketName
     *
     * @return bucketName */
    public String getBucketName() {
        return bucketName;
    }

    /** 设置 bucketName
     *
     * @param bucketName
     *        bucketName */
    public void setBucketName(String bucketName) {
        this.bucketName = bucketName;
    }

    /** 返回 accessUrl允许访问的url
     *
     * @return accessUrl允许访问的url */
    public String getAccessUrl() {
        return accessUrl;
    }

    /** 设置 accessUrl允许访问的url
     *
     * @param accessUrl
     *        accessUrl允许访问的url */
    public void setAccessUrl(String accessUrl) {
        this.accessUrl = accessUrl;
    }

    @Override
    public String toString() {
        return "OssConfig [endpoint=" + endpoint + ", accessKeyId=" + accessKeyId + ", accessKeySecret=" + accessKeySecret + ", accessUrl=" + accessUrl + ", bucketName=" + bucketName + "]";
    }

    public boolean check() {
        return isNotBlank(endpoint) && isNotBlank(accessKeyId) && isNotBlank(accessKeySecret) && isNotBlank(accessUrl) && isNotBlank(bucketName);
    }
}

