/*
 * Decompiled with CFR 0.152.
 */
package com.ohaotian.plugin.file.oss;

import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.ohaotian.plugin.file.AbstractFileClient;
import com.ohaotian.plugin.file.constant.FileType;
import com.ohaotian.plugin.file.oss.OssConfig;
import com.ohaotian.plugin.file.oss.OssUtil;
import com.ohaotian.plugin.file.util.FileUtils;
import java.io.File;
import java.io.InputStream;
import java.util.List;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@Component
public class OssFileClient
extends AbstractFileClient {
    private OssConfig ossConfig;
    @Value(value="${plugin.file.blackType:exe;bat;js;html;dll;jsp;}")
    private String fileUploadBlackType;

    public OssFileClient(OssConfig ossConfig) {
        this.ossConfig = ossConfig;
    }

    @Override
    public String uploadFileByInputStream(String uploadFilePath, String fileName, InputStream inputStream) {
        if (this.fileUploadBlackType.contains(FileUtils.ext(fileName))) {
            throw new ZTBusinessException("\u7981\u6b62\u4e0a\u4f20\u8be5\u6587\u4ef6\uff0c\u8bf7\u66f4\u6362\u540e\u91cd\u65b0\u4e0a\u4f20");
        }
        String filePath = this.getFilePath(uploadFilePath, fileName);
        OssUtil.uploadFileToOssByInputStream(filePath, this.ossConfig, inputStream);
        return filePath;
    }

    @Override
    public File downloadToFile(String filePath) {
        return OssUtil.downloadFile(filePath, this.ossConfig);
    }

    @Override
    public InputStream downLoadToInputStream(String filePath) {
        return OssUtil.downloadByInputStream(filePath, this.ossConfig);
    }

    @Override
    public List<String> listObjects(String prefix) {
        return OssUtil.listObjects(this.ossConfig, prefix);
    }

    @Override
    protected FileType getFileType() {
        return FileType.OSS;
    }
}

