package com.ohaotian.plugin.file.fastdfs;

import java.util.Properties;

import static org.apache.commons.lang3.StringUtils.isNotBlank;

/**
 * 标题：FastDFS 参数配置类
 * <p>
 * 说明：FastDFS 参数配置类
 * <br>
 * 时间：2018/07/09<br>
 * 版权：copyright © 2018 www.tydic.com Inc. All rights reserved.
 * </p>
 *
 * @author ZhangCheng
 */
public class FastdfsConfig {

    /**
     * 可选 是否开启防盗链功能（缺省值：false）
     */
    private String httpAntiStealToken;
    /**
     * 可选 开启防盗链功能时的key（缺省值：FastDFS1234567890）
     */
    private String httpSecretKey;
    /**
     * 必传 tracker HTTP 端口
     */
    private Integer httpTrackerHttpPort;
    /**
     * 必传 tracker 地址及端口，多个服务器之间用英文逗号隔开
     */
    private String trackerServers;

    public FastdfsConfig() {
    }

    public FastdfsConfig( String httpAntiStealToken, String httpSecretKey, Integer httpTrackerHttpPort, String trackerServers) {
        this.httpAntiStealToken = httpAntiStealToken;
        this.httpSecretKey = httpSecretKey;
        this.httpTrackerHttpPort = httpTrackerHttpPort;
        this.trackerServers = trackerServers;
    }

    public Properties getProperties(){
        Properties properties = new Properties();
        properties.setProperty("fastdfs.http_anti_steal_token",httpAntiStealToken);
        properties.setProperty("fastdfs.http_secret_key",httpSecretKey);
        properties.setProperty("fastdfs.http_tracker_http_port",httpTrackerHttpPort.toString());
        properties.setProperty("fastdfs.tracker_servers",trackerServers);
        return properties;
    }

    public boolean check() {
        return isNotBlank(httpAntiStealToken) && isNotBlank(httpSecretKey) && httpTrackerHttpPort != null && isNotBlank(trackerServers);
    }

    @Override
    public String toString() {
        return "FastdfsConfig{" +
                ", httpAntiStealToken='" + httpAntiStealToken + '\'' +
                ", httpSecretKey='" + httpSecretKey + '\'' +
                ", httpTrackerHttpPort='" + httpTrackerHttpPort + '\'' +
                ", trackerServers='" + trackerServers + '\'' +
                '}';
    }

    /**
     * 获取 可选 是否开启防盗链功能（缺省值：false）
     *
     * @return httpAntiStealToken 可选 是否开启防盗链功能（缺省值：false）
     */
    public String getHttpAntiStealToken() {
        return this.httpAntiStealToken;
    }

    /**
     * 设置 可选 是否开启防盗链功能（缺省值：false）
     *
     * @param httpAntiStealToken 可选 是否开启防盗链功能（缺省值：false）
     */
    public void setHttpAntiStealToken(String httpAntiStealToken) {
        this.httpAntiStealToken = httpAntiStealToken;
    }

    /**
     * 获取 可选 开启防盗链功能时的key（缺省值：FastDFS1234567890）
     *
     * @return httpSecretKey 可选 开启防盗链功能时的key（缺省值：FastDFS1234567890）
     */
    public String getHttpSecretKey() {
        return this.httpSecretKey;
    }

    /**
     * 设置 可选 开启防盗链功能时的key（缺省值：FastDFS1234567890）
     *
     * @param httpSecretKey 可选 开启防盗链功能时的key（缺省值：FastDFS1234567890）
     */
    public void setHttpSecretKey(String httpSecretKey) {
        this.httpSecretKey = httpSecretKey;
    }

    /**
     * 获取 必传 tracker HTTP 端口
     *
     * @return httpTrackerHttpPort 必传 tracker HTTP 端口
     */
    public Integer getHttpTrackerHttpPort() {
        return this.httpTrackerHttpPort;
    }

    /**
     * 设置 必传 tracker HTTP 端口
     *
     * @param httpTrackerHttpPort 必传 tracker HTTP 端口
     */
    public void setHttpTrackerHttpPort(Integer httpTrackerHttpPort) {
        this.httpTrackerHttpPort = httpTrackerHttpPort;
    }

    /**
     * 获取 必传 tracker 地址及端口，多个服务器之间用英文逗号隔开
     *
     * @return trackerServers 必传 tracker 地址及端口，多个服务器之间用英文逗号隔开
     */
    public String getTrackerServers() {
        return this.trackerServers;
    }

    /**
     * 设置 必传 tracker 地址及端口，多个服务器之间用英文逗号隔开
     *
     * @param trackerServers 必传 tracker 地址及端口，多个服务器之间用英文逗号隔开
     */
    public void setTrackerServers(String trackerServers) {
        this.trackerServers = trackerServers;
    }
}
