package com.ohaotian.plugin.file.ftp;


import static org.apache.commons.lang3.StringUtils.isNotBlank;

/**
 * <br>
 * 标题: ftp实体类<br>
 * 描述: <br>
 * 公司: www.tydic.com<br>
 *
 * @autho wesley
 * @time 2016年10月14日 下午5:49:27
 */
public class FtpConfig {

    /**
     * 主机地址
     */
    public String fileHost;

    /**
     * 主机密码
     */
    public String fileUser;

    /**
     * 主机密码
     */
    public String filePwd;

    /**
     * 端口
     */
    public Integer filePort;

    /**
     * 连接超时时间
     */
    public Integer timeOut;

    public FtpConfig() {
        super();
    }

    public FtpConfig(String fileHost, String fileUser, String filePwd, Integer filePort, Integer timeOut) {
        super();
        this.fileHost = fileHost;
        this.fileUser = fileUser;
        this.filePwd = filePwd;
        this.filePort = filePort;
        this.timeOut = timeOut;
    }

    /**
     * 返回 主机地址
     *
     * @return 主机地址
     */
    public String getFileHost() {
        return fileHost;
    }

    /**
     * 设置 主机地址
     *
     * @param fileHost 主机地址
     */
    public void setFileHost(String fileHost) {
        this.fileHost = fileHost;
    }

    /**
     * 返回 主机密码
     *
     * @return 主机密码
     */
    public String getFileUser() {
        return fileUser;
    }

    /**
     * 设置 主机密码
     *
     * @param fileUser 主机密码
     */
    public void setFileUser(String fileUser) {
        this.fileUser = fileUser;
    }

    /**
     * 返回 主机密码
     *
     * @return 主机密码
     */
    public String getFilePwd() {
        return filePwd;
    }

    /**
     * 设置 主机密码
     *
     * @param filePwd 主机密码
     */
    public void setFilePwd(String filePwd) {
        this.filePwd = filePwd;
    }

    /**
     * 返回 端口
     *
     * @return 端口
     */
    public Integer getFilePort() {
        return filePort;
    }

    /**
     * 设置 端口
     *
     * @param filePort 端口
     */
    public void setFilePort(Integer filePort) {
        this.filePort = filePort;
    }

    /**
     * 返回 连接超时时间
     *
     * @return 连接超时时间
     */
    public Integer getTimeOut() {
        return timeOut;
    }

    /**
     * 设置 连接超时时间
     *
     * @param timeOut 连接超时时间
     */
    public void setTimeOut(Integer timeOut) {
        this.timeOut = timeOut;
    }

    @Override
    public String toString() {
        return "FtpConfig [fileHost=" + fileHost + ", fileUser=" + fileUser + ", filePwd=" + filePwd + ", filePort=" + filePort + ", timeOut=" + timeOut + "]";
    }

    public boolean check() {
        return isNotBlank(fileHost) && isNotBlank(fileUser) && isNotBlank(filePwd) && filePort != null && timeOut != null;
    }
}

