/*
 * Decompiled with CFR 0.152.
 */
package com.ohaotian.plugin.file.fastdfs;

import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.ohaotian.plugin.file.AbstractFileClient;
import com.ohaotian.plugin.file.constant.FileType;
import com.ohaotian.plugin.file.fastdfs.FastdfsConfig;
import com.ohaotian.plugin.file.fastdfs.FastdfsFileInfo;
import com.ohaotian.plugin.file.fastdfs.FastdfsUtil;
import com.ohaotian.plugin.file.util.FileUtils;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.InputStream;
import java.util.Arrays;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;

public class FastdfsFileClient
extends AbstractFileClient {
    private static final Logger logger = LoggerFactory.getLogger(FastdfsFileClient.class);
    private FastdfsConfig fastdfsConfig;
    @Value(value="${plugin.file.blackType:exe;bat;js;html;dll;jsp;}")
    private String fileUploadBlackType;

    public FastdfsFileClient(FastdfsConfig fastdfsConfig) {
        this.fastdfsConfig = fastdfsConfig;
    }

    @Override
    public String uploadFileByInputStream(String uploadFilePath, String fileName, InputStream inputStream) {
        List<String> blackTypeList;
        String fileExtName = FileUtils.ext(fileName);
        String[] blackTypes = this.fileUploadBlackType.split(";");
        if (blackTypes != null && blackTypes.length > 0 && (blackTypeList = Arrays.asList(blackTypes)).contains(fileExtName)) {
            throw new ZTBusinessException("\u7981\u6b62\u4e0a\u4f20\u8be5\u6587\u4ef6\uff0c\u8bf7\u66f4\u6362\u540e\u91cd\u65b0\u4e0a\u4f20");
        }
        byte[] bytes = FileUtils.input2byte(inputStream);
        FastdfsFileInfo fileInfo = FastdfsUtil.uploadFile(fileName, this.fastdfsConfig, new ByteArrayInputStream(bytes), uploadFilePath);
        return FastdfsFileInfo.toFilePath(fileInfo);
    }

    @Override
    public File downloadToFile(String filePath) {
        return FastdfsUtil.downloadFile(FastdfsFileInfo.toFastdfsFileInfo(filePath), this.fastdfsConfig);
    }

    @Override
    public InputStream downLoadToInputStream(String filePath) {
        return FastdfsUtil.downloadByInputStream(FastdfsFileInfo.toFastdfsFileInfo(filePath), this.fastdfsConfig);
    }

    @Override
    protected FileType getFileType() {
        return FileType.FASTDFS;
    }
}

