package com.ohaotian.plugin.file.config;

import com.github.tobato.fastdfs.FdfsClientConfig;
import com.github.tobato.fastdfs.service.FastFileStorageClient;
import com.ohaotian.plugin.file.fastdfs.FastdfsUtil;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;

/**
 * FastDFS客户端自动配置
 */
@Configuration
@Import(FdfsClientConfig.class) // 导入tobato的配置
@EnableConfigurationProperties // 启用配置属性
public class FdfsAutoConfig {

    /**
     * 初始化工具类中的客户端
     */
    @Bean
    public FastdfsUtil fastdfsUtil(FastFileStorageClient storageClient) {
        FastdfsUtil.setStorageClient(storageClient);
        return new FastdfsUtil();
    }
}
