/*
 * Decompiled with CFR 0.152.
 */
package com.ohaotian.plugin.file.fastdfs;

import com.ohaotian.license.verify.service.LicenseVerifyService;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.ohaotian.plugin.file.AbstractFileClient;
import com.ohaotian.plugin.file.constant.FileType;
import com.ohaotian.plugin.file.fastdfs.FastdfsConfig;
import com.ohaotian.plugin.file.fastdfs.FastdfsFileInfo;
import com.ohaotian.plugin.file.fastdfs.FastdfsUtil;
import com.ohaotian.plugin.file.util.FileUtils;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.InputStream;
import java.net.URL;
import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;

public class FastdfsFileClient
extends AbstractFileClient {
    private static final Logger logger = LoggerFactory.getLogger(FastdfsFileClient.class);
    private FastdfsConfig fastdfsConfig;
    @Value(value="${plugin.file.blackType:exe;bat;js;html;dll;jsp;}")
    private String fileUploadBlackType;
    @Autowired
    private LicenseVerifyService licenseVerifyService;

    public FastdfsFileClient(FastdfsConfig fastdfsConfig) {
        this.fastdfsConfig = fastdfsConfig;
    }

    @Override
    public String uploadFileByInputStream(String uploadFilePath, String fileName, InputStream inputStream) {
        if (!this.licenseVerifyService.verify()) {
            throw new ZTBusinessException("\u8bc1\u4e66\u5df2\u8fc7\u671f\u6216\u5df2\u635f\u574f\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458");
        }
        byte[] bytes = FileUtils.input2byte(inputStream);
        String fileExtName = FileUtils.ext(fileName);
        if (!(!this.fileUploadBlackType.contains(FileUtils.getType(bytes)) || "mp4".equals(fileExtName) || "json".equals(fileExtName) || "txt".equals(fileExtName) || "p12".equals(fileExtName) || "pfx".equals(fileExtName) || "cer".equals(fileExtName))) {
            throw new ZTBusinessException("\u7981\u6b62\u4e0a\u4f20\u8be5\u6587\u4ef6\uff0c\u8bf7\u66f4\u6362\u540e\u91cd\u65b0\u4e0a\u4f20");
        }
        FastdfsFileInfo fileInfo = FastdfsUtil.uploadFile(fileName, this.fastdfsConfig, new ByteArrayInputStream(bytes), uploadFilePath);
        return FastdfsFileInfo.toFilePath(fileInfo);
    }

    @Override
    public String uploadFileByInputStream(String uploadFilePath, String fileName, InputStream inputStream, String accessAuth) {
        return this.uploadFileByInputStream(uploadFilePath, fileName, inputStream);
    }

    @Override
    public void setObjectAcl(String filePath, String accessAuth) {
        throw new ZTBusinessException("\u6682\u4e0d\u652f\u6301\u8be5\u65b9\u6cd5");
    }

    @Override
    public URL generatePresignedUrl(String filePath, Date expiration) {
        throw new ZTBusinessException("\u6682\u4e0d\u652f\u6301\u8be5\u65b9\u6cd5");
    }

    @Override
    public File downloadToFile(String filePath) {
        if (!this.licenseVerifyService.verify()) {
            throw new ZTBusinessException("\u8bc1\u4e66\u5df2\u8fc7\u671f\u6216\u5df2\u635f\u574f\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458");
        }
        return FastdfsUtil.downloadFile(FastdfsFileInfo.toFastdfsFileInfo(filePath), this.fastdfsConfig);
    }

    @Override
    public InputStream downLoadToInputStream(String filePath) {
        if (!this.licenseVerifyService.verify()) {
            throw new ZTBusinessException("\u8bc1\u4e66\u5df2\u8fc7\u671f\u6216\u5df2\u635f\u574f\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458");
        }
        return FastdfsUtil.downloadByInputStream(FastdfsFileInfo.toFastdfsFileInfo(filePath), this.fastdfsConfig);
    }

    @Override
    protected FileType getFileType() {
        return FileType.FASTDFS;
    }
}

