/*
 * Decompiled with CFR 0.152.
 */
package com.ohaotian.plugin.file.oss;

import com.aliyun.oss.ClientBuilderConfiguration;
import com.aliyun.oss.ClientException;
import com.aliyun.oss.OSS;
import com.aliyun.oss.OSSClientBuilder;
import com.aliyun.oss.OSSException;
import com.aliyun.oss.model.CannedAccessControlList;
import com.aliyun.oss.model.DeleteObjectsRequest;
import com.aliyun.oss.model.DeleteObjectsResult;
import com.aliyun.oss.model.GetObjectRequest;
import com.aliyun.oss.model.OSSObject;
import com.aliyun.oss.model.OSSObjectSummary;
import com.aliyun.oss.model.ObjectListing;
import com.aliyun.oss.model.ObjectMetadata;
import com.ohaotian.plugin.file.constant.OssFileAccessAuthEnum;
import com.ohaotian.plugin.file.oss.OssConfig;
import com.ohaotian.plugin.file.oss.OssContentType;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Date;
import java.util.List;
import java.util.UUID;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.StringUtils;

public class OssUtil {
    private static final Logger log = LoggerFactory.getLogger(OssUtil.class);
    private static OSS ossClient;

    public static OSS getOssclient(OssConfig ossConfig) {
        if (ossClient == null) {
            ClientBuilderConfiguration conf = new ClientBuilderConfiguration();
            conf.setSupportCname(false);
            ossClient = new OSSClientBuilder().build(ossConfig.getEndpoint(), ossConfig.getAccessKeyId(), ossConfig.getAccessKeySecret());
        }
        return ossClient;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void uploadFile(File file, OssConfig ossConfig, String uploadPath) {
        String fileName = file.getName();
        InputStream content = null;
        try {
            OSS ossClient = OssUtil.getOssclient(ossConfig);
            content = new FileInputStream(file);
            ObjectMetadata meta = new ObjectMetadata();
            meta.setContentLength(file.length());
            ossClient.putObject(ossConfig.getBucketName(), uploadPath + fileName, content, meta);
        }
        catch (OSSException e) {
            log.error("\u8fde\u63a5\u8fdc\u7a0boss\u670d\u52a1\u5668\u51fa\u9519\uff01", (Throwable)e);
        }
        catch (FileNotFoundException e) {
            log.error("\u68c0\u67e5\u6587\u4ef6\u3010" + fileName + "\u662f\u5426\u5b58\u5728\u3011", (Throwable)e);
        }
        catch (ClientException e) {
            log.error("\u8fde\u63a5oss\u5ba2\u6237\u7aef\u51fa\u9519\uff01", (Throwable)e);
        }
        finally {
            try {
                content.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public static void uploadFileByInputStream(String fileName, OssConfig ossConfig, InputStream inputStream, String uploadPath) {
        try {
            OSS ossClient = OssUtil.getOssclient(ossConfig);
            ossClient.putObject(ossConfig.getBucketName(), uploadPath + fileName, inputStream);
        }
        catch (OSSException e) {
            log.error("\u8fde\u63a5\u8fdc\u7a0boss\u670d\u52a1\u5668\u51fa\u9519\uff01", (Throwable)e);
        }
        catch (ClientException e) {
            log.error("\u8fde\u63a5oss\u5ba2\u6237\u7aef\u51fa\u9519\uff01", (Throwable)e);
        }
    }

    public static void uploadFileToOssByInputStream(String filePath, OssConfig ossConfig, InputStream inputStream) {
        try {
            OSS ossClient = OssUtil.getOssclient(ossConfig);
            ossClient.putObject(ossConfig.getBucketName(), filePath, inputStream);
        }
        catch (OSSException e) {
            log.error("\u8fde\u63a5\u8fdc\u7a0boss\u670d\u52a1\u5668\u51fa\u9519\uff01", (Throwable)e);
        }
        catch (ClientException e) {
            log.error("\u8fde\u63a5oss\u5ba2\u6237\u7aef\u51fa\u9519\uff01", (Throwable)e);
        }
    }

    public static void uploadFileToOssByInputStream(String fileExtName, String filePath, OssConfig ossConfig, InputStream inputStream) {
        try {
            OSS ossClient = OssUtil.getOssclient(ossConfig);
            ObjectMetadata objectMetadata = new ObjectMetadata();
            objectMetadata.setContentType(OssContentType.of(fileExtName));
            ossClient.putObject(ossConfig.getBucketName(), filePath, inputStream, objectMetadata);
        }
        catch (OSSException e) {
            log.error("\u8fde\u63a5\u8fdc\u7a0boss\u670d\u52a1\u5668\u51fa\u9519\uff01", (Throwable)e);
        }
        catch (ClientException e) {
            log.error("\u8fde\u63a5oss\u5ba2\u6237\u7aef\u51fa\u9519\uff01", (Throwable)e);
        }
    }

    public static void uploadFileToOssByInputStream(String fileExtName, String filePath, OssConfig ossConfig, InputStream inputStream, String accessAuth) {
        OSS ossClient = null;
        try {
            boolean isHtmlType;
            ossClient = OssUtil.getOssclient(ossConfig);
            ObjectMetadata objectMetadata = new ObjectMetadata();
            objectMetadata.setContentType(OssContentType.of(fileExtName));
            objectMetadata.setContentLength((long)inputStream.available());
            if (StringUtils.hasText((String)accessAuth)) {
                CannedAccessControlList cannedAcl = OssFileAccessAuthEnum.getAccessControlByCode(accessAuth);
                objectMetadata.setObjectAcl(cannedAcl);
            }
            boolean bl = isHtmlType = StringUtils.hasText((String)fileExtName) && ("htm".equalsIgnoreCase(fileExtName) || "html".equalsIgnoreCase(fileExtName));
            if (isHtmlType) {
                objectMetadata.setContentDisposition("inline");
            }
            ossClient.putObject(ossConfig.getBucketName(), filePath, inputStream, objectMetadata);
        }
        catch (OSSException e) {
            log.error("OSS\u670d\u52a1\u7aef\u9519\u8bef", (Throwable)e);
        }
        catch (ClientException e) {
            log.error("OSS\u5ba2\u6237\u7aef\u9519\u8bef", (Throwable)e);
        }
        catch (IOException e) {
            log.error("\u6587\u4ef6\u6d41\u5904\u7406\u6216\u7f16\u7801\u9519\u8bef", (Throwable)e);
        }
    }

    public static File downloadFile(String filePath, OssConfig ossConfig) {
        OSS ossClient = OssUtil.getOssclient(ossConfig);
        String fileName = UUID.randomUUID() + filePath.substring(filePath.lastIndexOf("."), filePath.length());
        String dir = System.getProperty("java.io.tmpdir");
        fileName = dir + File.separator + fileName;
        File dirFile = new File(dir);
        if (!dirFile.exists()) {
            dirFile.mkdirs();
        }
        dirFile = new File(fileName);
        try {
            GetObjectRequest getObjectRequest = new GetObjectRequest(ossConfig.getBucketName(), filePath);
            ossClient.getObject(getObjectRequest, dirFile);
        }
        catch (Throwable e) {
            log.error("\u4eceoss\u4e0a\u4e0b\u8f7d\u6587\u4ef6,bucketName\uff1a" + ossConfig.getBucketName() + ";osskey\uff1a" + filePath + ";\u4e0b\u8f7d\u7684\u6587\u4ef6\u8def\u5f84:" + fileName, e);
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new RuntimeException(e);
        }
        return dirFile;
    }

    public static InputStream downloadByInputStream(String filePath, OssConfig ossConfig) {
        InputStream in = null;
        OSS ossClient = OssUtil.getOssclient(ossConfig);
        try {
            OSSObject ossObject = ossClient.getObject(ossConfig.getBucketName(), filePath);
            in = ossObject.getObjectContent();
        }
        catch (Throwable e) {
            log.error("\u4eceoss\u4e0a\u4e0b\u8f7d\u6587\u4ef6,bucketName\uff1a" + ossConfig.getBucketName() + ";osskey\uff1a" + filePath, e);
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new RuntimeException(e);
        }
        return in;
    }

    public static void setObjectAcl(String filePath, OssConfig ossConfig, String accessAuth) {
        CannedAccessControlList cannedAcl = OssFileAccessAuthEnum.getAccessControlByCode(accessAuth);
        OSS ossClient = OssUtil.getOssclient(ossConfig);
        try {
            ossClient.setObjectAcl(ossConfig.getBucketName(), filePath, cannedAcl);
        }
        catch (Throwable e) {
            log.error("\u4fee\u6539\u6587\u4ef6\u6743\u9650,bucketName\uff1a" + ossConfig.getBucketName() + ";osskey\uff1a" + filePath, e);
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new RuntimeException(e);
        }
    }

    public static URL generatePresignedUrl(String filePath, OssConfig ossConfig, Date expiration) {
        URL url = null;
        try {
            OSS ossClient = OssUtil.getOssclient(ossConfig);
            url = ossClient.generatePresignedUrl(ossConfig.getBucketName(), filePath, expiration);
            return url;
        }
        catch (OSSException e) {
            log.error("\u83b7\u53d6\u4e34\u65f6\u7b7e\u540dURL\u51fa\u9519\uff01", (Throwable)e);
        }
        catch (ClientException e) {
            log.error("\u8fde\u63a5oss\u5ba2\u6237\u7aef\u51fa\u9519\uff01", (Throwable)e);
        }
        return url;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void deleteFile(String filePath, OssConfig ossConfig) {
        OSS ossClient = OssUtil.getOssclient(ossConfig);
        try {
            ossClient.deleteObject(ossConfig.getBucketName(), filePath);
        }
        catch (OSSException e) {
            log.error("Caught an OSSException, which means your request made it to OSS, but was rejected with an error response for some reason.");
        }
        catch (ClientException e) {
            log.error("Caught an ClientException, which means the client encountered a serious internal problem while trying to communicate with OSS, such as not being able to access the network.");
        }
        finally {
            ossClient.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<String> listObjects(OssConfig ossConfig, String prefix) {
        List<String> list;
        OSS ossClient = OssUtil.getOssclient(ossConfig);
        try {
            ObjectListing objectListing = ossClient.listObjects(ossConfig.getBucketName(), prefix);
            List sums = objectListing.getObjectSummaries();
            list = sums.stream().map(OSSObjectSummary::getKey).collect(Collectors.toList());
        }
        finally {
            ossClient.shutdown();
        }
        return list;
    }

    public static void deleteFiles(List<String> filePaths, OssConfig ossConfig) {
        if (filePaths == null || filePaths.isEmpty()) {
            log.warn("\u6279\u91cf\u5220\u9664OSS\u6587\u4ef6\u65f6\uff0c\u6587\u4ef6\u8def\u5f84\u5217\u8868\u4e3a\u7a7a\uff0c\u65e0\u9700\u5904\u7406");
            return;
        }
        OSS ossClient = OssUtil.getOssclient(ossConfig);
        try {
            DeleteObjectsRequest deleteRequest = new DeleteObjectsRequest(ossConfig.getBucketName());
            deleteRequest.setKeys(filePaths);
            DeleteObjectsResult result = ossClient.deleteObjects(deleteRequest);
            List deletedKeys = result.getDeletedObjects();
            if (deletedKeys != null && !deletedKeys.isEmpty()) {
                log.info("\u6279\u91cf\u5220\u9664OSS\u6587\u4ef6\u6210\u529f\uff0c\u5220\u9664\u7684\u6587\u4ef6\u8def\u5f84\uff1a{}", (Object)deletedKeys);
            }
        }
        catch (OSSException e) {
            log.error("\u6279\u91cf\u5220\u9664OSS\u6587\u4ef6\u65f6\uff0cOSS\u670d\u52a1\u8fd4\u56de\u9519\u8bef\uff01", (Throwable)e);
        }
        catch (ClientException e) {
            log.error("\u6279\u91cf\u5220\u9664OSS\u6587\u4ef6\u65f6\uff0c\u5ba2\u6237\u7aef\u901a\u4fe1\u51fa\u9519\uff01", (Throwable)e);
        }
    }

    private static String getFileNameFromPath(String filePath) {
        int lastBackslashIndex;
        if (StringUtils.isEmpty((Object)filePath)) {
            return "unknown_file";
        }
        int lastSlashIndex = filePath.lastIndexOf("/");
        int separatorIndex = Math.max(lastSlashIndex, lastBackslashIndex = filePath.lastIndexOf("\\"));
        return separatorIndex == -1 ? filePath : filePath.substring(separatorIndex + 1);
    }
}

