/*
 * Decompiled with CFR 0.152.
 */
package com.ohaotian.plugin.file.cos;

import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.ohaotian.plugin.file.AbstractFileClient;
import com.ohaotian.plugin.file.constant.FileType;
import com.ohaotian.plugin.file.cos.CosConfig;
import com.ohaotian.plugin.file.util.FileUtils;
import com.qcloud.cos.COSClient;
import com.qcloud.cos.ClientConfig;
import com.qcloud.cos.auth.BasicCOSCredentials;
import com.qcloud.cos.auth.COSCredentials;
import com.qcloud.cos.model.ObjectMetadata;
import com.qcloud.cos.model.PutObjectRequest;
import com.qcloud.cos.region.Region;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLDecoder;
import java.util.Date;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.util.StringUtils;

public class CosFileClient
extends AbstractFileClient {
    private static final Logger log = LoggerFactory.getLogger(CosFileClient.class);
    @Value(value="${plugin.file.blackType:exe;bat;js;html;dll;jsp;zip;rar}")
    private String fileUploadBlackType;
    private CosConfig cosConfig;

    public CosFileClient() {
    }

    public CosFileClient(CosConfig cosConfig) {
        this.cosConfig = cosConfig;
    }

    @Override
    public String uploadFileByInputStream(String uploadFilePath, String fileName, InputStream inputStream) {
        return this.uploadFileByInputStream(uploadFilePath, fileName, inputStream, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public String uploadFileByInputStream(String uploadFilePath, String fileName, InputStream inputStream, String accessAuth) {
        fileName = fileName.replace("\\+", "");
        fileName = fileName.replace("%2B", "");
        String fileExtName = FileUtils.ext(fileName = fileName.replace("+", ""));
        if (!StringUtils.hasText((String)fileExtName)) {
            throw new ZTBusinessException("\u7981\u6b62\u4e0a\u4f20\u65e0\u7c7b\u578b\u6587\u4ef6\uff0c\u8bf7\u66f4\u6362\u540e\u91cd\u65b0\u4e0a\u4f20");
        }
        if (!(!this.fileUploadBlackType.contains(fileExtName) || "mp4".equals(fileExtName) || "json".equals(fileExtName) || "txt".equals(fileExtName) || "p12".equals(fileExtName) || "pfx".equals(fileExtName) || "cer".equals(fileExtName))) {
            throw new ZTBusinessException("\u7981\u6b62\u4e0a\u4f20\u8be5\u6587\u4ef6\uff0c\u8bf7\u66f4\u6362\u540e\u91cd\u65b0\u4e0a\u4f20");
        }
        String objectName = "";
        objectName = uploadFilePath.endsWith("/") || fileName.startsWith("/") ? uploadFilePath + fileName : uploadFilePath + "/" + fileName;
        try {
            BasicCOSCredentials cred = new BasicCOSCredentials(this.cosConfig.getAccessKeyId(), this.cosConfig.getAccessKeySecret());
            ClientConfig clientConfig = new ClientConfig(new Region(this.cosConfig.getRegion()));
            COSClient cosclient = new COSClient((COSCredentials)cred, clientConfig);
            try {
                String decodedPath;
                ObjectMetadata metadata = new ObjectMetadata();
                metadata.setContentType("application/octet-stream");
                PutObjectRequest putObjectRequest = new PutObjectRequest(this.cosConfig.getBucketName(), objectName, inputStream, metadata);
                cosclient.putObject(putObjectRequest);
                String string = decodedPath = URLDecoder.decode(objectName, "UTF-8");
                return string;
            }
            catch (Exception e) {
                e.printStackTrace();
                return null;
            }
            finally {
                cosclient.shutdown();
            }
        }
        catch (Exception e2) {
            e2.printStackTrace();
            log.error("Minio\u6587\u4ef6\u4e0a\u4f20\u5931\u8d25," + e2.getMessage());
        }
        return null;
    }

    @Override
    public void setObjectAcl(String filePath, String accessAuth) {
        throw new ZTBusinessException("\u6682\u4e0d\u652f\u6301\u8be5\u65b9\u6cd5");
    }

    @Override
    public URL generatePresignedUrl(String filePath, Date expiration) {
        throw new ZTBusinessException("\u6682\u4e0d\u652f\u6301\u8be5\u65b9\u6cd5");
    }

    @Override
    public void deleteFiles(List<String> filePaths) {
    }

    public static String keepAfterFourthSlash(String url) {
        int count = 0;
        int index = 0;
        for (int i = 0; i < url.length(); ++i) {
            if (url.charAt(i) != '/' || ++count != 4) continue;
            index = i;
            break;
        }
        return url.substring(index + 1);
    }

    @Override
    public File downloadToFile(String filePath) {
        String fileName = filePath.substring(filePath.lastIndexOf("/"), filePath.length());
        String dir = System.getProperty("java.io.tmpdir");
        fileName = !dir.endsWith("/") ? dir + File.separator + fileName : dir + fileName;
        File dirFile = new File(dir);
        if (!dirFile.exists()) {
            dirFile.mkdirs();
        }
        dirFile = new File(fileName);
        try {
            int bytesRead;
            InputStream inputStream = this.downLoadToInputStream(filePath);
            FileOutputStream outputStream = new FileOutputStream(dirFile);
            byte[] buffer = new byte[1024];
            while ((bytesRead = inputStream.read(buffer)) != -1) {
                ((OutputStream)outputStream).write(buffer, 0, bytesRead);
            }
            ((OutputStream)outputStream).close();
            inputStream.close();
            return dirFile;
        }
        catch (Exception e) {
            e.printStackTrace();
            log.error("Minio\u6587\u4ef6\u4e0b\u8f7d\u5931\u8d25,filePath=" + filePath + ",\u5f02\u5e38=" + e.getMessage());
            return null;
        }
    }

    @Override
    public InputStream downLoadToInputStream(String filePath) {
        if (!filePath.startsWith("/")) {
            filePath = "/" + filePath;
        }
        String fileUrl = this.cosConfig.getEndPoint() + filePath;
        try {
            URL url = new URL(fileUrl);
            HttpURLConnection connection = (HttpURLConnection)url.openConnection();
            connection.setRequestMethod("GET");
            connection.setDoInput(true);
            connection.setDoOutput(false);
            connection.connect();
            int responseCode = connection.getResponseCode();
            if (responseCode == 200) {
                return new BufferedInputStream(connection.getInputStream());
            }
            throw new IOException("Failed to download file: HTTP error code : " + responseCode);
        }
        catch (Exception e) {
            e.printStackTrace();
            log.error("Cos\u6587\u4ef6\u4e0b\u8f7d\u5931\u8d25,filePath=" + filePath + ",\u5f02\u5e38=" + e.getMessage());
            return null;
        }
    }

    @Override
    protected FileType getFileType() {
        return FileType.MINIO;
    }
}

