/*
 * Decompiled with CFR 0.152.
 */
package com.ohaotian.plugin.file;

import com.ohaotian.plugin.file.FileClient;
import com.ohaotian.plugin.file.constant.FileType;
import com.ohaotian.plugin.file.fastdfs.FastdfsConfig;
import com.ohaotian.plugin.file.fastdfs.FastdfsFileClient;
import com.ohaotian.plugin.file.ftp.FtpConfig;
import com.ohaotian.plugin.file.ftp.FtpFileClient;
import com.ohaotian.plugin.file.minio.MinioConfig;
import com.ohaotian.plugin.file.minio.MinioFileClient;
import com.ohaotian.plugin.file.obs.ObsConfig;
import com.ohaotian.plugin.file.obs.ObsFileClient;
import com.ohaotian.plugin.file.oss.OssConfig;
import com.ohaotian.plugin.file.oss.OssFileClient;

public class FileClientFactory {
    public static FileClient getOssClient(String endpoint, String accesskey, String accessKeySecret, String bucketName, String accessUrl) {
        OssConfig ossConfig = new OssConfig(endpoint, accesskey, accessKeySecret, bucketName, accessUrl);
        return FileClientFactory.getOssClient(ossConfig);
    }

    public static FileClient getOssClient(OssConfig ossConfig) {
        return FileClientFactory.getFileClient(FileType.OSS, ossConfig);
    }

    public static FileClient getObsClient(ObsConfig obsConfig) {
        return FileClientFactory.getFileClient(FileType.OBS, obsConfig);
    }

    public static FileClient getMinioClient(MinioConfig minioConfig) {
        return FileClientFactory.getFileClient(FileType.MINIO, minioConfig);
    }

    public static FileClient getFtpClient(String ftpHost, String ftpUser, String ftpPwd, Integer ftpPort, Integer ftpTimeout) {
        FtpConfig ftpConfig = new FtpConfig(ftpHost, ftpUser, ftpPwd, ftpPort, ftpTimeout);
        return FileClientFactory.getFtpClient(ftpConfig);
    }

    public static FileClient getFtpClient(FtpConfig ftpConfig) {
        return FileClientFactory.getFileClient(FileType.FTP, ftpConfig);
    }

    public static FileClient getFastdfsClient(String httpAntiStealToken, String httpSecretKey, Integer httpTrackerHttpPort, String trackerServers) {
        FastdfsConfig fastdfsConfig = new FastdfsConfig(httpAntiStealToken, httpSecretKey, httpTrackerHttpPort, trackerServers);
        return FileClientFactory.getFastdfsClient(fastdfsConfig);
    }

    public static FileClient getFastdfsClient(FastdfsConfig fastdfsConfig) {
        return FileClientFactory.getFileClient(FileType.FASTDFS, fastdfsConfig);
    }

    private static FileClient getFileClient(FileType fileType, Object configObject) {
        switch (fileType) {
            case FTP: {
                return new FtpFileClient((FtpConfig)configObject);
            }
            case OSS: {
                return new OssFileClient((OssConfig)configObject);
            }
            case OBS: {
                return new ObsFileClient((ObsConfig)configObject);
            }
            case MINIO: {
                return new MinioFileClient((MinioConfig)configObject);
            }
            case FASTDFS: {
                return new FastdfsFileClient((FastdfsConfig)configObject);
            }
        }
        throw new IllegalArgumentException("plugin-file config not support this file type [" + (Object)((Object)fileType) + "]");
    }
}

