/*
 * Decompiled with CFR 0.152.
 */
package com.ohaotian.plugin.file.controller;

import com.ohaotian.plugin.base.annotation.BusiResponseBody;
import com.ohaotian.plugin.file.FileClient;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/plugin/noauth/file/download/"})
public class PluginNoauthFileDownloadController {
    private static final Logger log = LoggerFactory.getLogger(PluginNoauthFileDownloadController.class);
    @Value(value="${plugin.file.type:}")
    private String fileType;
    @Autowired
    private FileClient fileClient;
    private final Object lock = new Object();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RequestMapping(value={"/**"})
    @BusiResponseBody
    public void download(HttpServletResponse response, HttpServletRequest request) throws IOException {
        InputStream in = null;
        String fullPath = request.getRequestURI();
        String url = "";
        String repalceStr = "/plugin/noauth/file/download";
        if (this.fileType.equals("OSS")) {
            repalceStr = "/plugin/noauth/file/download/";
        }
        int index = fullPath.indexOf(repalceStr);
        url = fullPath.substring(index + repalceStr.length(), fullPath.length());
        url = url.replaceAll("\\+", "%2B");
        url = URLDecoder.decode(url, "UTF-8");
        url = url.replaceAll("%2B", "+");
        try {
            int bytesRead;
            File file;
            if (this.fileType.equals("OSS") && url.startsWith("/")) {
                url = url.substring(1);
            }
            log.debug("plugin-file\u4e0b\u8f7d\uff1a{}", (Object)url);
            Object object = this.lock;
            synchronized (object) {
                file = this.fileClient.downloadToFile(url);
            }
            response.setCharacterEncoding("UTF-8");
            response.setContentType("application/octet-stream");
            String fileName = url.substring(url.lastIndexOf("/") + 1, url.length());
            fileName = URLEncoder.encode(fileName, StandardCharsets.UTF_8.toString());
            response.setHeader("Content-Disposition", "attachment; filename*=UTF-8''" + fileName);
            in = new BufferedInputStream(new FileInputStream(file));
            ServletOutputStream out = response.getOutputStream();
            byte[] buffer = new byte[1024];
            while ((bytesRead = in.read(buffer)) != -1) {
                out.write(buffer, 0, bytesRead);
            }
            out.flush();
        }
        catch (Exception e) {
            log.error("plugin-file\u4e0b\u8f7d\uff1a{},\u53d1\u751f\u5f02\u5e38", (Object)url, (Object)e);
            String errMsg = "plugin-file\u4e0b\u8f7d" + url + ",\u53d1\u751f\u5f02\u5e38 " + e.getMessage();
            response.sendError(500, errMsg);
            response.setContentType("text/html;charset=UTF-8");
            PrintWriter out = response.getWriter();
            out.write(errMsg);
            out.close();
        }
        finally {
            if (in != null) {
                in.close();
            }
        }
    }
}

