/*
 * Decompiled with CFR 0.152.
 */
package com.ohaotian.plugin.mock;

import com.ohaotian.plugin.mock.AnnotationHandle;
import com.ohaotian.plugin.mock.AutoinjectHandle;
import com.ohaotian.plugin.mock.exception.FieldsNotFoundException;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import org.springframework.aop.support.AopUtils;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.context.ApplicationContext;

public class MockProcessor
implements BeanPostProcessor {
    private static List<AnnotationHandle> globalHandles = new ArrayList<AnnotationHandle>();
    @Autowired
    private ApplicationContext applicationContext;

    public Object postProcessBeforeInitialization(Object bean, String beanName) throws BeansException {
        return this.invokeBean(bean, beanName);
    }

    public Object postProcessAfterInitialization(Object bean, String beanName) throws BeansException {
        return this.invokeBean(bean, beanName);
    }

    private Object invokeBean(Object bean, String beanName) {
        Field[] fields;
        for (Field field : fields = this.getDeclaredFields(bean)) {
            for (AnnotationHandle handle : globalHandles) {
                if (!handle.hasExist(field)) continue;
                bean = handle.invok(bean, beanName, field, this.applicationContext);
            }
        }
        return bean;
    }

    private Field[] getDeclaredFields(Object bean) {
        if (AopUtils.isAopProxy((Object)bean)) {
            try {
                return bean.getClass().getSuperclass().getDeclaredFields();
            }
            catch (SecurityException e) {
                e.printStackTrace();
                throw new FieldsNotFoundException("Mock get bean '" + bean.getClass().getSuperclass().getSimpleName() + "' declared fields not found ");
            }
        }
        return bean.getClass().getDeclaredFields();
    }

    static {
        globalHandles.add(new AutoinjectHandle());
    }
}

