/*
 * Decompiled with CFR 0.152.
 */
package com.ohaotian.plugin.mock;

import com.ohaotian.plugin.mock.AnnotationHandle;
import com.ohaotian.plugin.mock.annotation.Autoinject;
import com.ohaotian.plugin.mock.annotation.InjectType;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanInitializationException;
import org.springframework.context.ApplicationContext;

public class AutoinjectHandle
implements AnnotationHandle {
    private static Logger logger = LoggerFactory.getLogger(AutoinjectHandle.class);

    @Override
    public boolean hasExist(Field field) {
        if (field == null) {
            return false;
        }
        for (Annotation annotation : field.getDeclaredAnnotations()) {
            if (!(annotation instanceof Autoinject)) continue;
            return true;
        }
        return false;
    }

    @Override
    public Object invok(Object bean, String beanName, Field field, ApplicationContext applicationContext) throws BeansException {
        Autoinject autoMock = field.getDeclaredAnnotation(Autoinject.class);
        if (InjectType.MOCK == autoMock.value() && this.hasBeanMock(field)) {
            this.invokLog(beanName, field, autoMock, InjectType.MOCK);
            return this.getBeanByMock(bean, field);
        }
        if (InjectType.WIRED == autoMock.value()) {
            Object beanImpl = this.findBeanImpl(field, applicationContext);
            if (null != beanImpl) {
                this.invokLog(beanName, field, autoMock, InjectType.WIRED);
                return this.getBeanByImpl(bean, field, beanImpl);
            }
            if (this.hasBeanMock(field)) {
                this.invokLog(beanName, field, autoMock, InjectType.MOCK);
                return this.getBeanByMock(bean, field);
            }
        }
        if (InjectType.MOCK == autoMock.value()) {
            throw new BeanInitializationException("Mock bean exception: \u540d\u79f0\u4e3a '" + beanName + "' \u7684\u5b57\u6bb5 '" + field.getName() + "' mock\u5305\u4e0b\u6ca1\u6709impl\u7c7b");
        }
        throw new BeanInitializationException("Mock bean exception: \u540d\u79f0\u4e3a '" + beanName + "' \u7684\u5b57\u6bb5 '" + field.getName() + "' mock\u5305\u548cimpl\u5305\u4e0b\u90fd\u6ca1\u6709impl\u7c7b");
    }

    private void invokLog(String beanName, Field field, Autoinject autoMock, InjectType injectType) {
        if (logger.isInfoEnabled()) {
            logger.info("\u5b8c\u6210\u91cd\u65b0\u88c5\u914dBean\u540d\u79f0\u4e3a '" + beanName + "' \u7684\u5b57\u6bb5\u540d\u79f0\u4e3a '" + field.getName() + "' \u88c5\u914d\u7c7b\u578b\u4e3a '" + (Object)((Object)autoMock.value()) + "' \u5b9e\u9645\u88c5\u914d\u7c7b\u578b\u4e3a '" + (Object)((Object)injectType) + "'");
        }
    }

    private Object getBeanByImpl(Object bean, Field field, Object beanImpl) throws BeansException {
        try {
            field.setAccessible(true);
            field.set(bean, beanImpl);
            return bean;
        }
        catch (Exception e) {
            throw new BeanInitializationException("Bean\u521d\u59cb\u5316\u5f02\u5e38\uff0c" + e.getMessage());
        }
    }

    private Object getBeanByMock(Object bean, Field field) {
        try {
            String mockPakcage = field.getType().getPackage().getName() + ".mock";
            String mockName = field.getType().getSimpleName() + "Impl";
            String clazzName = mockPakcage + "." + mockName;
            Class<?> clazz = Class.forName(clazzName);
            field.setAccessible(true);
            field.set(bean, clazz.newInstance());
            return bean;
        }
        catch (Exception e) {
            throw new BeanInitializationException("Bean\u521d\u59cb\u5316\u5f02\u5e38\uff0c" + e.getMessage());
        }
    }

    private Object findBeanImpl(Field field, ApplicationContext applicationContext) {
        Object bean = null;
        try {
            bean = applicationContext.getBean(field.getName() + "Impl");
        }
        catch (BeansException e) {
            try {
                bean = applicationContext.getParent().getBean(field.getName() + "Impl");
            }
            catch (BeansException e1) {
                try {
                    bean = applicationContext.getParent().getBean(field.getName());
                }
                catch (BeansException e2) {
                    logger.error("Can't find the implement of {}", (Object)field.getName());
                }
            }
        }
        return bean;
    }

    private boolean hasBeanMock(Field field) {
        try {
            String mockPakcage = field.getType().getPackage().getName() + ".mock";
            String mockName = field.getType().getSimpleName() + "Impl";
            String clazzName = mockPakcage + "." + mockName;
            Class<?> clazz = Class.forName(clazzName);
            clazz.newInstance();
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }
}

