package com.ohaotian.plugin.mq.proxy;

import com.ohaotian.plugin.mq.proxy.callback.ProxyLocalTransactionExecuter;
import com.ohaotian.plugin.mq.proxy.callback.ProxySendCallback;

/**
 * 标题：消息生产者
 * <p>
 * 说明：消息生产者
 * <br>
 * 时间：2018/06/26<br>
 * 版权：copyright © 2018 www.tydic.com Inc. All rights reserved.
 * </p>
 *
 * @author Please creater enter the name
 * @author ZhangCheng
 */
public interface ProxyMessageProducer {

    /**
     * 发送同步消息
     *
     * @param message 消息
     * @return 结果
     */
    ProxySendResult send(ProxyMessage message);

    /**
     * 发送异步消息
     *
     * @param message      消息
     * @param sendCallback 回调对象
     */
    void send(ProxyMessage message, ProxySendCallback sendCallback);

    /**
     * 发送单向消息
     *
     * @param message 消息
     */
    void sendOneway(ProxyMessage message);

    /**
     * 发送半事务消息
     *
     * @param proxyMessage             消息
     * @param localTransactionExecuter 事务执行器
     * @param arg                      参数
     * @return 结果
     */
    ProxySendResult sendInTransaction(final ProxyMessage proxyMessage, final ProxyLocalTransactionExecuter localTransactionExecuter, final Object arg);
}
