package com.ohaotian.plugin.mq.proxy.config;

import org.springframework.context.annotation.Configuration;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.Iterator;
import java.util.Properties;
import java.util.Set;

/*
* 辅助加载application.properties 文件
* */
@Configuration
public class LoadProperties extends Properties {
    public LoadProperties(){
        File upLev = new File(System.getProperty("user.dir")+ File.separator+"../config"+File.separator+"application.properties");
        File samLev = new File(System.getProperty("user.dir")+ File.separator+"config"+File.separator+"application.properties");
        InputStream classpath = LoadProperties.class.getClassLoader().getResourceAsStream("application.properties");
        try {
            Properties properties = new Properties();

            System.out.println(upLev.getAbsolutePath());
            if(upLev.exists()){
                FileInputStream inUp = new FileInputStream(upLev);
                properties.load(inUp);
            }
            System.out.println(samLev.getAbsolutePath());
            if(samLev.exists()){
                FileInputStream inSam = new FileInputStream(samLev);
                properties.load(inSam);
            }
            System.out.println("加载classpath:application.properties");
            if(classpath != null){
                properties.load(classpath);
            }
            Set<Object> keys = properties.keySet();
            Iterator<Object> iterator = keys.iterator();
            while(iterator.hasNext()){
                String key = (String)iterator.next();
                String value = properties.getProperty(key);
                super.setProperty(key,value);
            }
        } catch (Exception e) {
            e.printStackTrace();
        }
    }



}
