package com.ohaotian.plugin.mq.proxy.ext.defaultmq;

import com.ohaotian.plugin.mq.proxy.*;
import com.ohaotian.plugin.mq.proxy.callback.ProxyLocalTransactionExecuter;
import com.ohaotian.plugin.mq.proxy.callback.ProxySendCallback;
import com.ohaotian.plugin.mq.proxy.constants.LogUtils;
import com.ohaotian.plugin.mq.proxy.constants.MessageConfigUtils;
import com.ohaotian.plugin.mq.proxy.ext.ProxyMessageProducerEx;
import com.ohaotian.plugin.mq.proxy.internal.ProxyMessageConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;

import java.util.Map;

/**
 * 标题：默认生产者，当关闭MQ插件时，返回此生产者
 * <p>
 * 说明：默认生产者，当关闭MQ插件时，返回此生产者
 * <br>
 * 时间：2018/07/27<br>
 * 版权：copyright © 2018 www.tydic.com Inc. All rights reserved.
 * </p>
 *
 * @author ZhangCheng
 */
public class DefaultMqMessageSender implements ProxyMessageProducerEx, ApplicationContextAware {

    private static final Logger logger = LoggerFactory.getLogger(DefaultMqMessageSender.class);

    public DefaultMqMessageSender(ProxyMessageConfig config, Map map) {
        // No thing to do
    }

    public ProxySendResult send(ProxyMessage message) {
        this.showDisableTip(message);
        return this.makeSendFail(message);
    }

    public void send(ProxyMessage message, ProxySendCallback sendCallback) {
        this.showDisableTip(message);
        sendCallback.onSuccess(this.makeSendFail(message));
    }

    public void sendOneway(ProxyMessage message) {
        this.showDisableTip(message);
    }

    public ProxySendResult sendInTransaction(ProxyMessage message, ProxyLocalTransactionExecuter localTransactionExecuter, Object arg) {
        this.showDisableTip(message);
        return this.makeSendFail(message);
    }

    private void showDisableTip(ProxyMessage message){
        LogUtils.warn(logger,"已禁用插件，不发送消息，如果您要启用插件，请修改 ["+ MessageConfigUtils.Keys.Mq.ENABLE+"] 的值为 [true]");
        LogUtils.debug(logger,"未发送的消息为：",message);
    }

    private ProxySendResult makeSendFail(ProxyMessage message){
        ProxySendResult result = new ProxySendResult();
        result.setMsgId(message.getMessageId());
        result.setStatus(ProxySendResult.SEND_FAIL);
        return result;
    }

    public void startup() {
        // No thing to do
    }

    public void shutdown() {
        // No thing to do
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        // No thing to do
    }
}
