package com.ohaotian.plugin.mq.proxy.ext.rocketmq;

import com.ohaotian.plugin.mq.proxy.ProxyMessage;
import com.ohaotian.plugin.mq.proxy.impl.IProxyMessageConsumerWrapper;
import org.apache.rocketmq.client.consumer.listener.*;
import org.apache.rocketmq.common.message.MessageExt;

import java.util.List;
import java.util.Set;

public class RocketMQMessageListener  implements MessageListenerConcurrently, MessageListenerOrderly {
    private final Set<IProxyMessageConsumerWrapper> localConsumers;

    RocketMQMessageListener(Set<IProxyMessageConsumerWrapper> localConsumers) {
        this.localConsumers = localConsumers;
    }

    public ConsumeConcurrentlyStatus consumeMessage(List<MessageExt> messageExts, ConsumeConcurrentlyContext consumeConcurrentlyContext) {
        processMessage(messageExts, localConsumers);
        return ConsumeConcurrentlyStatus.CONSUME_SUCCESS;
    }

    public ConsumeOrderlyStatus consumeMessage(List<MessageExt> messageExts, ConsumeOrderlyContext consumeOrderlyContext) {
        processMessage(messageExts, localConsumers);
        return ConsumeOrderlyStatus.SUCCESS;
    }

    private void processMessage(List<MessageExt> messageExts, Set<IProxyMessageConsumerWrapper> localConsumers) {
        for (MessageExt messageExt : messageExts) {
            ProxyMessage message = RocketMQMessageConsumerRegister.getMessage(messageExt);
            for (IProxyMessageConsumerWrapper proxyMessageConsumer : localConsumers) {
                if (!proxyMessageConsumer.needWrapper(message.getSubject(), message.getTag())) {
                    continue;
                }
                proxyMessageConsumer.onMessage(message);
            }
        }
    }
}