/*
 * Decompiled with CFR 0.152.
 */
package com.ohaotian.plugin.mq.proxy.ext.aliyunmq;

import com.aliyun.openservices.ons.api.Consumer;
import com.aliyun.openservices.ons.api.Message;
import com.aliyun.openservices.ons.api.MessageListener;
import com.aliyun.openservices.ons.api.ONSFactory;
import com.ohaotian.plugin.mq.proxy.ProxyMessage;
import com.ohaotian.plugin.mq.proxy.ProxyMessageType;
import com.ohaotian.plugin.mq.proxy.constants.Strategy;
import com.ohaotian.plugin.mq.proxy.ext.aliyunmq.AliyunMessageListener;
import com.ohaotian.plugin.mq.proxy.impl.ConsumerRegisterInfo;
import com.ohaotian.plugin.mq.proxy.impl.MQRegister;
import com.ohaotian.plugin.mq.proxy.impl.MQUtils;
import java.io.UnsupportedEncodingException;
import java.util.Map;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.util.CollectionUtils;

public class AliyunMQMessageConsumerRegister
implements MQRegister,
ApplicationContextAware {
    private final Logger logger = LoggerFactory.getLogger((String)this.getClass().getName());
    private Properties mergedProps = new Properties();
    private Consumer consumer;
    private boolean started;

    @Override
    public void register(ConsumerRegisterInfo consumerInfo) {
        ProxyMessageType[] messageTypes;
        String subject = consumerInfo.getSubject();
        for (ProxyMessageType messageType : messageTypes = consumerInfo.getMessageTypes()) {
            if (this.supportConcurrently(messageType)) continue;
            throw new UnsupportedOperationException("Unsuppoorted messageType[" + (Object)((Object)messageType) + "] for subject[" + consumerInfo.getSubject() + "]");
        }
        Properties config = new Properties();
        Properties consumerProps = consumerInfo.getProperties();
        config.put("ConsumerId", consumerInfo.getCid());
        config.put("AccessKey", consumerProps.getProperty("mq.accessKey", this.mergedProps.getProperty("mq.accessKey")));
        config.put("SecretKey", consumerProps.getProperty("mq.secretKey", this.mergedProps.getProperty("mq.secretKey")));
        config.put("ONSAddr", consumerProps.getProperty("mq.onsAddr", this.mergedProps.getProperty("mq.onsAddr")));
        this.consumer = ONSFactory.createConsumer((Properties)config);
        this.consumer.subscribe(subject, MQUtils.tags2Line(consumerInfo.getTags()), (MessageListener)new AliyunMessageListener(consumerInfo.getConsumerWrappers()));
    }

    private boolean supportConcurrently(ProxyMessageType messageType) {
        return messageType == ProxyMessageType.ASYNCHRONOUS || messageType == ProxyMessageType.SYNCHRONIZATION || messageType == ProxyMessageType.ONEWAY || messageType == ProxyMessageType.TRANSACTION;
    }

    protected static ProxyMessage getMessage(Message aliyunMessage) {
        ProxyMessage message;
        try {
            message = new ProxyMessage(aliyunMessage.getTopic(), aliyunMessage.getTag(), new String(aliyunMessage.getBody(), "UTF-8"));
            message.setMessageId(aliyunMessage.getMsgID());
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalArgumentException("aliyumMessage 2 ProxyMessage Error", e);
        }
        return message;
    }

    @Override
    public boolean support(String strategy) {
        return AliyunMQMessageConsumerRegister.strategySupported(strategy);
    }

    public static boolean strategySupported(String strategy) {
        return Strategy.isAliyunMQ(strategy);
    }

    @Override
    public void startup() {
        if (this.started) {
            return;
        }
        this.consumer.start();
        this.started = true;
    }

    @Override
    public void shutdown() {
        if (!this.started) {
            return;
        }
        this.consumer.shutdown();
        this.started = false;
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        Map propsMapping = applicationContext.getBeansOfType(Properties.class);
        if (propsMapping != null) {
            for (Properties props : propsMapping.values()) {
                CollectionUtils.mergePropertiesIntoMap((Properties)props, (Map)this.mergedProps);
            }
        }
    }
}

