/*
 * Decompiled with CFR 0.152.
 */
package com.ohaotian.plugin.mq.proxy.ext.rocketmq;

import com.ohaotian.plugin.mq.proxy.CacheStore;
import com.ohaotian.plugin.mq.proxy.DefaultProxyMessageConfig;
import com.ohaotian.plugin.mq.proxy.ProxyExceptionContext;
import com.ohaotian.plugin.mq.proxy.ProxyMessage;
import com.ohaotian.plugin.mq.proxy.ProxyMessageType;
import com.ohaotian.plugin.mq.proxy.ProxySendResult;
import com.ohaotian.plugin.mq.proxy.callback.ProxyLocalTransactionExecuter;
import com.ohaotian.plugin.mq.proxy.callback.ProxySendCallback;
import com.ohaotian.plugin.mq.proxy.ext.ProxyMessageProducerEx;
import com.ohaotian.plugin.mq.proxy.ext.rocketmq.RocketMqTransactionCheckListener;
import com.ohaotian.plugin.mq.proxy.internal.ProxyMessageConfig;
import com.ohaotian.plugin.mq.proxy.internal.ProxyMessageException;
import com.ohaotian.plugin.mq.proxy.status.ProxyTransactionStatus;
import java.io.UnsupportedEncodingException;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.UUID;
import org.apache.rocketmq.client.exception.MQClientException;
import org.apache.rocketmq.client.producer.DefaultMQProducer;
import org.apache.rocketmq.client.producer.LocalTransactionExecuter;
import org.apache.rocketmq.client.producer.LocalTransactionState;
import org.apache.rocketmq.client.producer.SendCallback;
import org.apache.rocketmq.client.producer.SendResult;
import org.apache.rocketmq.client.producer.TransactionCheckListener;
import org.apache.rocketmq.client.producer.TransactionMQProducer;
import org.apache.rocketmq.client.producer.TransactionSendResult;
import org.apache.rocketmq.common.message.Message;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.util.CollectionUtils;

public class RocketMqMessageSender
implements ProxyMessageProducerEx,
ApplicationContextAware {
    private final Logger logger = LoggerFactory.getLogger((String)this.getClass().getName());
    private DefaultMQProducer producer;
    private TransactionMQProducer transProductor;
    private final String subject;
    private final Map<ProxyMessageType, Set<String>> typeTagsMapping;
    private RocketMqTransactionCheckListener transactionCheckerListener;
    private CacheStore cacheStore;
    private Properties mergedProps = new Properties();
    private final ProxyMessageConfig messageConfig;
    private final int[] data = new int[]{1, 5, 10, 30, 60, 120, 180, 240, 300, 360, 420, 480, 540, 600, 1200, 1800, 3600, 7200};

    public RocketMqMessageSender(ProxyMessageConfig messageConfig, Map<ProxyMessageType, Set<String>> typeTagsMapping) {
        this.subject = messageConfig.getSubject();
        this.messageConfig = messageConfig;
        this.typeTagsMapping = typeTagsMapping;
    }

    @Override
    public ProxySendResult send(ProxyMessage message) {
        ProxySendResult proxySendResult;
        this.checkStatus(message, ProxyMessageType.SYNCHRONIZATION);
        try {
            SendResult sendResult = this.producer.send(this.getMessage(message));
            proxySendResult = this.getProxySendResult(sendResult);
        }
        catch (Exception e) {
            throw new ProxyMessageException("send subject[" + message.getSubject() + "] tag[" + message.getTag() + "] error", e);
        }
        return proxySendResult;
    }

    @Override
    public ProxySendResult sendInTransaction(final ProxyMessage proxyMessage, final ProxyLocalTransactionExecuter localTransactionExecuter, Object arg) {
        ProxySendResult proxySendResult;
        this.checkStatus(proxyMessage, ProxyMessageType.TRANSACTION);
        Message message = this.getMessage(proxyMessage);
        try {
            TransactionSendResult sendResult = this.transProductor.sendMessageInTransaction(message, new LocalTransactionExecuter(){

                public LocalTransactionState executeLocalTransactionBranch(Message message, Object arg) {
                    ProxyTransactionStatus transactionStatus = localTransactionExecuter.exec(proxyMessage, arg);
                    if (transactionStatus == ProxyTransactionStatus.COMMIT) {
                        return LocalTransactionState.COMMIT_MESSAGE;
                    }
                    if (transactionStatus == ProxyTransactionStatus.ROLLBACK) {
                        return LocalTransactionState.ROLLBACK_MESSAGE;
                    }
                    if (transactionStatus == ProxyTransactionStatus.UNKNOW) {
                        return LocalTransactionState.UNKNOW;
                    }
                    return LocalTransactionState.UNKNOW;
                }
            }, arg);
            proxySendResult = this.getProxySendResult((SendResult)sendResult);
            this.cacheStore.set(sendResult.getMsgId(), ProxyTransactionStatus.COMMIT.toString(), 600);
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("send tran msg msgId={" + proxySendResult.getMsgId() + "}  topic=" + proxyMessage.getSubject() + " tag=" + proxyMessage.getTag() + "  body={" + proxyMessage.getContent() + "}  SendResult={" + proxySendResult.getStatus() + "}");
            }
        }
        catch (Exception e) {
            throw new ProxyMessageException("send subject[" + proxyMessage.getSubject() + "] tag[" + proxyMessage.getTag() + "] error", e);
        }
        return proxySendResult;
    }

    private ProxySendResult getProxySendResult(SendResult sendResult) {
        ProxySendResult proxySendResult = new ProxySendResult();
        proxySendResult.setMsgId(sendResult.getMsgId());
        proxySendResult.setStatus(sendResult.getSendStatus().name());
        return proxySendResult;
    }

    private Message getMessage(ProxyMessage message) {
        Message sendMessage;
        try {
            sendMessage = new Message(message.getSubject(), message.getTag(), message.getContent().getBytes("UTF-8"));
            if (message.getDelaySendTime() > 0) {
                sendMessage.setDelayTimeLevel(this.minL(message.getDelaySendTime()));
            }
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException("Convert rocketmq message error", e);
        }
        return sendMessage;
    }

    private int minL(int time) {
        for (int i = 1; i <= this.data.length; ++i) {
            if (this.data[i - 1] - time > 0) {
                return i - 1;
            }
            if (this.data[i - 1] - time == 0) {
                return i;
            }
            if (i != this.data.length) continue;
            return i;
        }
        return 14;
    }

    @Override
    public void send(ProxyMessage message, final ProxySendCallback sendCallback) {
        this.checkStatus(message, ProxyMessageType.ASYNCHRONOUS);
        try {
            this.producer.send(this.getMessage(message), new SendCallback(){

                public void onSuccess(SendResult sendResult) {
                    if (sendCallback != null) {
                        sendCallback.onSuccess(RocketMqMessageSender.this.getProxySendResult(sendResult));
                    }
                }

                public void onException(Throwable e) {
                    if (sendCallback != null) {
                        sendCallback.onException(new ProxyExceptionContext(e));
                    }
                }
            });
        }
        catch (Throwable e) {
            if (sendCallback != null) {
                sendCallback.onException(new ProxyExceptionContext(e));
            }
            throw new ProxyMessageException("send subject[" + message.getSubject() + "] tag[" + message.getTag() + "] error", e);
        }
    }

    private void checkStatus(ProxyMessage message, ProxyMessageType proxyMessageType) {
    }

    @Override
    public void sendOneway(ProxyMessage message) {
        this.checkStatus(message, ProxyMessageType.ONEWAY);
        try {
            this.producer.sendOneway(this.getMessage(message));
        }
        catch (Throwable e) {
            throw new ProxyMessageException("send subject[" + message.getSubject() + "] tag[" + message.getTag() + "] error", e);
        }
    }

    @Override
    public void startup() {
        if (this.typeTagsMapping.containsKey((Object)ProxyMessageType.TRANSACTION)) {
            this.transProductor = new TransactionMQProducer(((DefaultProxyMessageConfig)this.messageConfig).getId());
            this.transactionCheckerListener = new RocketMqTransactionCheckListener();
            this.transactionCheckerListener.setCacheStore(this.cacheStore);
        } else {
            this.transProductor = null;
        }
        boolean createCommonProductor = false;
        if (this.typeTagsMapping.containsKey((Object)ProxyMessageType.SYNCHRONIZATION)) {
            createCommonProductor = true;
        }
        if (!createCommonProductor && this.typeTagsMapping.containsKey((Object)ProxyMessageType.ASYNCHRONOUS)) {
            createCommonProductor = true;
        }
        if (!createCommonProductor && this.typeTagsMapping.containsKey((Object)ProxyMessageType.ONEWAY)) {
            createCommonProductor = true;
        }
        if (!createCommonProductor && this.typeTagsMapping.containsKey((Object)ProxyMessageType.ORDERED)) {
            createCommonProductor = true;
        }
        this.producer = createCommonProductor ? new DefaultMQProducer(((DefaultProxyMessageConfig)this.messageConfig).getId()) : null;
        try {
            if (this.producer != null) {
                this.producer.setNamesrvAddr(this.messageConfig.getProperties().getProperty("mq.rocket.namesrvaddr", this.mergedProps.getProperty("mq.rocket.namesrvaddr")));
                this.producer.setInstanceName(UUID.randomUUID().toString());
                this.producer.setRetryTimesWhenSendFailed(0);
                this.producer.setRetryTimesWhenSendAsyncFailed(0);
                this.producer.start();
            }
            if (this.transProductor != null) {
                this.transProductor.setNamesrvAddr(this.messageConfig.getProperties().getProperty("mq.rocket.namesrvaddr", this.mergedProps.getProperty("mq.rocket.namesrvaddr")));
                this.transProductor.setInstanceName(UUID.randomUUID().toString());
                this.transProductor.setTransactionCheckListener((TransactionCheckListener)this.transactionCheckerListener);
                this.transProductor.setCheckThreadPoolMinSize(5);
                this.transProductor.setCheckThreadPoolMaxSize(50);
                this.transProductor.setCheckRequestHoldMax(2000);
                this.transProductor.start();
            }
        }
        catch (MQClientException e) {
            throw new ProxyMessageException("start product[" + this.subject + "] error", e);
        }
    }

    @Override
    public void shutdown() {
        if (this.producer != null) {
            this.producer.shutdown();
        }
        if (this.transProductor != null) {
            this.transProductor.shutdown();
        }
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.cacheStore = (CacheStore)applicationContext.getBean(CacheStore.class);
        Map propsMapping = applicationContext.getBeansOfType(Properties.class);
        if (propsMapping != null) {
            for (Properties props : propsMapping.values()) {
                CollectionUtils.mergePropertiesIntoMap((Properties)props, (Map)this.mergedProps);
            }
        }
    }
}

