package com.ohaotian.plugin.mq.proxy.ext.rabbitmq;

import com.rabbitmq.client.Channel;
import com.rabbitmq.client.Connection;
import com.rabbitmq.client.ConnectionFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.util.CollectionUtils;

import java.util.Map;
import java.util.Properties;

/**
 * @描述：
 * @作者： 李佳琪
 * @时间 2020-04-10
 */
public class RabbitMQUtil implements ApplicationContextAware {
    private static Properties mergedProps = new Properties();
    public static Channel getChannelInstance(String connectionDescription, Properties properties) {
        try {
            ConnectionFactory connectionFactory = getConnectionFactory(properties);
            Connection connection = connectionFactory.newConnection(connectionDescription);
            return connection.createChannel();
        } catch (Exception e) {
            throw new RuntimeException("获取Channel连接失败"+e.getMessage());
        }
    }

    private static ConnectionFactory getConnectionFactory(Properties properties) {
        //TODO  初始化时机
        ConnectionFactory connectionFactory = new ConnectionFactory();
        // 配置连接信息
        connectionFactory.setHost(properties.getProperty("mq.onsAddr").split(":")[0]);
        connectionFactory.setPort(Integer.parseInt(properties.getProperty("mq.onsAddr").split(":")[1]));
        connectionFactory.setVirtualHost(properties.getProperty("mq.rabbit.virtualHost"));
        connectionFactory.setUsername(properties.getProperty("mq.rabbit.username"));
        connectionFactory.setPassword(properties.getProperty("mq.rabbit.password"));

        // 网络异常自动连接恢复
        connectionFactory.setAutomaticRecoveryEnabled(true);
        // 每5秒尝试重试连接一次
        connectionFactory.setNetworkRecoveryInterval(5000);

        return connectionFactory;
    }

    @Override
    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        Map<String, Properties> propsMapping = applicationContext.getBeansOfType(Properties.class);
        if (propsMapping != null) {
            for (Properties props : propsMapping.values()) {
                CollectionUtils.mergePropertiesIntoMap(props, mergedProps);
            }
        }
    }
}
