package com.ohaotian.plugin.mq.proxy.ext;

import com.ohaotian.plugin.mq.proxy.ProxyMessageType;
import com.ohaotian.plugin.mq.proxy.impl.MQRegister;
import com.ohaotian.plugin.mq.proxy.internal.ProxyMessageConfig;

import java.util.Map;
import java.util.Set;

public class ExtInfo {
    private Class<MQRegister> registerClass;
    private Class<ProxyMessageProducerEx> senderClass;

    public Class<MQRegister> getRegisterClass() {
        return registerClass;
    }

    public void setRegisterClass(Class<MQRegister> registerClass) {
        this.registerClass = registerClass;
    }

    public Class<ProxyMessageProducerEx> getSenderClass() {
        return senderClass;
    }

    public void setSenderClass(Class<ProxyMessageProducerEx> senderClass) {
        this.senderClass = senderClass;
    }

    public boolean registerSupported(String strategy) {
        boolean supported = false;
        try {
            supported = (Boolean) this.registerClass.getMethod("strategySupported", String.class).invoke(this.registerClass, strategy);
        } catch (IllegalStateException e) {
            throw e;
        } catch (Throwable e) {
            throw new IllegalStateException("check register registerSupported error", e);
        }
        return supported;
    }

    public MQRegister newRegister() {
        MQRegister mqRegister;
        try {
            mqRegister = this.registerClass.newInstance();
        } catch (Throwable e) {
            throw new IllegalStateException("create mq register[" + this.registerClass.getName() + "] error", e);
        }
        return mqRegister;
    }

    public ProxyMessageProducerEx newProducer(ProxyMessageConfig messageConfig, Map<ProxyMessageType, Set<String>> typeTagsMapping) {
        ProxyMessageProducerEx mqSender;
        try {
            mqSender = this.senderClass.getConstructor(ProxyMessageConfig.class, Map.class).newInstance(messageConfig, typeTagsMapping);
        } catch (Throwable e) {
            throw new IllegalStateException("create mq sender[" + this.senderClass.getName() + "] error", e);
        }
        return mqSender;
    }

    public static void main(String[] args) throws Exception {
        Class<MQRegister> clazz = (Class<MQRegister>) Class.forName("com.ohaotian.plugin.mq.proxy.ext.rocketmq.RocketMQMessageConsumerRegister");
        System.out.println(clazz.getMethod("strategySupported", String.class).invoke(clazz, "RocketMQ"));
    }
}
