package com.ohaotian.plugin.mq.proxy.ext.aliyunmq;

import com.aliyun.openservices.ons.api.Action;
import com.aliyun.openservices.ons.api.ConsumeContext;
import com.aliyun.openservices.ons.api.Message;
import com.aliyun.openservices.ons.api.MessageListener;
import com.ohaotian.plugin.mq.proxy.ProxyMessage;
import com.ohaotian.plugin.mq.proxy.ProxyMessageConsumer;
import com.ohaotian.plugin.mq.proxy.impl.IProxyMessageConsumerWrapper;

import java.util.Set;

public class AliyunMessageListener implements MessageListener {
    private final Set<IProxyMessageConsumerWrapper> localConsumers;

    AliyunMessageListener(Set<IProxyMessageConsumerWrapper> localConsumers) {
        this.localConsumers = localConsumers;
    }

    public Action consume(Message message, ConsumeContext consumeContext) {
        processMessage(message, localConsumers);
        return Action.CommitMessage;
    }

    @Override
    public String toString() {
        return "AliyunMessageListener";
    }

    @Override
    public int hashCode() {
        return this.toString().hashCode();
    }

    @Override
    public boolean equals(Object obj) {
        return obj != null && obj.getClass() == this.getClass() && this.toString().equals(obj.toString());
    }

    private void processMessage(Message aliyunMessage, Set<IProxyMessageConsumerWrapper> localConsumers) {
        ProxyMessage message = AliyunMQMessageConsumerRegister.getMessage(aliyunMessage);
        for (ProxyMessageConsumer proxyMessageConsumer : localConsumers) {
            proxyMessageConsumer.onMessage(message);
        }
    }
}