package com.ohaotian.plugin.mq.proxy.ext.defaultmq;

import com.ohaotian.plugin.mq.proxy.ProxyMessageType;
import com.ohaotian.plugin.mq.proxy.constants.Strategy;
import com.ohaotian.plugin.mq.proxy.impl.ConsumerRegisterInfo;
import com.ohaotian.plugin.mq.proxy.impl.MQRegister;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;

/**
 * 标题：默认消费者注册
 * <p>
 * 说明：默认消费者注册
 * <br>
 * 时间：2018/07/27<br>
 * 版权：copyright © 2018 www.tydic.com Inc. All rights reserved.
 * </p>
 *
 * @author ZhangCheng
 */
public class DefaultMqMessageConsumerRegister implements MQRegister, ApplicationContextAware {

    public void register(ConsumerRegisterInfo consumerInfo) {
        // No thing to do
    }

    private boolean supportConcurrently(ProxyMessageType messageType) {
        return messageType == ProxyMessageType.ASYNCHRONOUS || messageType == ProxyMessageType.SYNCHRONIZATION || messageType == ProxyMessageType.ONEWAY || messageType == ProxyMessageType.TRANSACTION;
    }

    public boolean support(String strategy) {
        return DefaultMqMessageConsumerRegister.strategySupported(strategy);
    }

    public static boolean strategySupported(String strategy) {
        return Strategy.isDefaultMQ(strategy);
    }

    public void startup() {
        // No thing to do
    }

    public void shutdown() {
        // No thing to do
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        // No thing to do
    }
}
