package com.ohaotian.plugin.mq.proxy.support;

import java.lang.annotation.*;

/**
 * 标题：消费者注解
 * <p>
 * 说明：消费者注解
 * <br>
 * 时间：2018/07/25<br>
 * 版权：copyright © 2018 www.tydic.com Inc. All rights reserved.
 * </p>
 *
 * @author ZhangCheng
 */
@Documented
@Target(ElementType.TYPE)
@Retention(RetentionPolicy.RUNTIME)
public @interface MqProxyConsumer {

    /**
     * 消费者ID
     *
     * @return ID
     */
    String id() default "";

    /**
     * 消费者订阅主题
     *
     * @return 主题
     */
    String subject() default "";

    /**
     * 消费者订阅标签
     *
     * @return 标签
     */
    String[] tags() default "";
}
