/*
 * Decompiled with CFR 0.152.
 */
package com.ohaotian.plugin.mq.proxy.ext.rabbitmq;

import com.ohaotian.plugin.mq.proxy.ProxyMessage;
import com.ohaotian.plugin.mq.proxy.ProxyMessageType;
import com.ohaotian.plugin.mq.proxy.constants.Strategy;
import com.ohaotian.plugin.mq.proxy.ext.rabbitmq.RabbitMQUtil;
import com.ohaotian.plugin.mq.proxy.impl.ConsumerRegisterInfo;
import com.ohaotian.plugin.mq.proxy.impl.MQRegister;
import com.rabbitmq.client.AMQP;
import com.rabbitmq.client.BuiltinExchangeType;
import com.rabbitmq.client.Channel;
import com.rabbitmq.client.Consumer;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.apache.rocketmq.common.message.MessageExt;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.util.CollectionUtils;

public class RabbitMQMessageConsumerRegister
implements MQRegister,
ApplicationContextAware {
    private Properties mergedProps = new Properties();
    private boolean started;
    private Consumer consumer;

    @Override
    public void register(ConsumerRegisterInfo consumerInfo) {
        ProxyMessageType[] messageTypes;
        String subject = consumerInfo.getSubject();
        for (ProxyMessageType messageType : messageTypes = consumerInfo.getMessageTypes()) {
            if (this.supportConcurrently(messageType)) continue;
            throw new UnsupportedOperationException("Unsuppoorted messageType[" + (Object)((Object)messageType) + "] for subject[" + consumerInfo.getSubject() + "]");
        }
        Channel channel = RabbitMQUtil.getChannelInstance("\u6d88\u8d39\u8005\u542f\u52a8\u4e00\u4e2a\u9891\u9053");
        try {
            AMQP.Queue.DeclareOk declareOk = channel.queueDeclare("rabbitmq.wj.add", true, false, false, new HashMap());
            channel.exchangeDeclare("rabbitmq.wj", BuiltinExchangeType.TOPIC, true, false, false, new HashMap());
            channel.queueBind(declareOk.getQueue(), "rabbitmq.wj", "add", new HashMap());
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        this.consumer = channel.getDefaultConsumer();
    }

    @Override
    public boolean support(String strategy) {
        return RabbitMQMessageConsumerRegister.strategySupported(strategy);
    }

    @Override
    public void startup() {
        if (this.started) {
            return;
        }
        this.started = true;
    }

    @Override
    public void shutdown() {
        if (!this.started) {
            return;
        }
        this.started = false;
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        Map propsMapping = applicationContext.getBeansOfType(Properties.class);
        if (propsMapping != null) {
            for (Properties props : propsMapping.values()) {
                CollectionUtils.mergePropertiesIntoMap((Properties)props, (Map)this.mergedProps);
            }
        }
    }

    public static boolean strategySupported(String strategy) {
        return Strategy.isRabbitMQ(strategy);
    }

    private boolean supportConcurrently(ProxyMessageType messageType) {
        return messageType == ProxyMessageType.ASYNCHRONOUS || messageType == ProxyMessageType.SYNCHRONIZATION || messageType == ProxyMessageType.ONEWAY || messageType == ProxyMessageType.TRANSACTION;
    }

    protected static ProxyMessage getMessage(MessageExt messageExt) {
        ProxyMessage message;
        try {
            message = new ProxyMessage(messageExt.getTopic(), messageExt.getTags(), new String(messageExt.getBody(), "UTF-8"));
            message.setMessageId(messageExt.getMsgId());
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalArgumentException("MessageExt 2 ProxyMessage Error", e);
        }
        return message;
    }
}

