/*
 * Decompiled with CFR 0.152.
 */
package com.ohaotian.plugin.mq.proxy.ext.rabbitmq;

import com.ohaotian.plugin.mq.proxy.CacheStore;
import com.ohaotian.plugin.mq.proxy.ProxyMessage;
import com.ohaotian.plugin.mq.proxy.ProxyMessageType;
import com.ohaotian.plugin.mq.proxy.ProxySendResult;
import com.ohaotian.plugin.mq.proxy.callback.ProxyLocalTransactionExecuter;
import com.ohaotian.plugin.mq.proxy.callback.ProxySendCallback;
import com.ohaotian.plugin.mq.proxy.ext.ProxyMessageProducerEx;
import com.ohaotian.plugin.mq.proxy.ext.rabbitmq.RabbitMQUtil;
import com.ohaotian.plugin.mq.proxy.internal.ProxyMessageConfig;
import com.rabbitmq.client.AMQP;
import com.rabbitmq.client.BuiltinExchangeType;
import com.rabbitmq.client.Channel;
import com.rabbitmq.client.Consumer;
import com.rabbitmq.client.DefaultConsumer;
import com.rabbitmq.client.Envelope;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.util.CollectionUtils;

public class RabbitMqMessageSender
implements ProxyMessageProducerEx,
ApplicationContextAware {
    private final Logger logger = LoggerFactory.getLogger((String)this.getClass().getName());
    private CacheStore cacheStore;
    private final Properties mergedProps = new Properties();
    private Channel channel;
    private ProxyMessageConfig messageConfig;
    private final String subject;
    private final Map<ProxyMessageType, Set<String>> typeTagsMapping;

    public RabbitMqMessageSender(ProxyMessageConfig messageConfig, Map<ProxyMessageType, Set<String>> typeTagsMapping) {
        this.logger.info("[" + this.getClass().getName() + "] rabbitMQ----");
        this.subject = messageConfig.getSubject();
        this.messageConfig = messageConfig;
        this.typeTagsMapping = typeTagsMapping;
    }

    @Override
    public void startup() {
        this.channel = RabbitMQUtil.getChannelInstance("\u961f\u5217\u6d88\u606f\u751f\u4ea7\u8005");
        try {
            String exchangeName = "rabbitmq.wj";
            String routingKey = "rkey";
            this.channel.exchangeDeclare(exchangeName, BuiltinExchangeType.DIRECT, true, false, false, new HashMap());
            String queueName = this.channel.queueDeclare().getQueue();
            this.channel.queueDeclare();
            this.channel.queueBind(queueName, exchangeName, routingKey);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void shutdown() {
    }

    @Override
    public ProxySendResult send(ProxyMessage message) {
        AMQP.BasicProperties basicProperties = new AMQP.BasicProperties().builder().deliveryMode(Integer.valueOf(2)).contentType("UTF-8").build();
        String testConsumerTag = "";
        try {
            testConsumerTag = this.channel.basicConsume("rabbitmq.wj.add", false, "testConsumerTag", (Consumer)new DefaultConsumer(this.channel){

                public void handleDelivery(String consumerTag, Envelope envelope, AMQP.BasicProperties properties, byte[] body) throws IOException {
                    System.out.println(envelope);
                    System.out.println(new String(body));
                    long tag = envelope.getDeliveryTag();
                    if (tag / 2L == 0L) {
                        RabbitMqMessageSender.this.channel.basicReject(tag, true);
                    } else {
                        RabbitMqMessageSender.this.channel.basicAck(envelope.getDeliveryTag(), true);
                    }
                }
            });
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return this.getProxySendResult(testConsumerTag);
    }

    private ProxySendResult getProxySendResult(String sendResult) {
        ProxySendResult proxySendResult = new ProxySendResult();
        proxySendResult.setMsgId(sendResult);
        proxySendResult.setStatus("SEND_OK");
        return proxySendResult;
    }

    @Override
    public void send(ProxyMessage message, ProxySendCallback sendCallback) {
    }

    @Override
    public void sendOneway(ProxyMessage message) {
    }

    @Override
    public ProxySendResult sendInTransaction(ProxyMessage proxyMessage, ProxyLocalTransactionExecuter localTransactionExecuter, Object arg) {
        return null;
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        Map propsMapping = applicationContext.getBeansOfType(Properties.class);
        if (propsMapping != null) {
            for (Properties props : propsMapping.values()) {
                CollectionUtils.mergePropertiesIntoMap((Properties)props, (Map)this.mergedProps);
            }
        }
        this.cacheStore = (CacheStore)applicationContext.getBean(CacheStore.class);
    }
}

