package com.ohaotian.plugin.mq.proxy.ext.rabbitmq;

import com.ohaotian.plugin.mq.proxy.ProxyMessage;
import com.ohaotian.plugin.mq.proxy.ProxyMessageConsumer;
import com.ohaotian.plugin.mq.proxy.impl.IProxyMessageConsumerWrapper;
import com.rabbitmq.client.AMQP;
import com.rabbitmq.client.Channel;
import com.rabbitmq.client.DefaultConsumer;
import com.rabbitmq.client.Envelope;

import java.io.IOException;
import java.util.Set;


public class RabbitMqMessageListener extends DefaultConsumer {
    private final Set<IProxyMessageConsumerWrapper> localConsumers;
    private String queueName;
    private Channel channel;
    private boolean autoAck;
    private String consumerTag;

    public RabbitMqMessageListener(String queueName, boolean autoAck, String consumerTag, Channel channel, Set<IProxyMessageConsumerWrapper> consumerWrappers) {
        super(channel);
        this.queueName = queueName;
        this.autoAck = autoAck;
        this.consumerTag = consumerTag;
        this.channel = channel;
        this.localConsumers = consumerWrappers;
    }

    @Override
    public void handleDelivery(String consumerTag, Envelope envelope, AMQP.BasicProperties properties, byte[] body) throws IOException {
        processMessage(localConsumers, new String(body),envelope, channel);
    }

    protected void processMessage(Set<IProxyMessageConsumerWrapper> localConsumers, String msg, Envelope envelope, Channel channel) {
        try {
            ProxyMessage message = new ProxyMessage(envelope.getRoutingKey(),queueName,String.valueOf(envelope.getDeliveryTag()),consumerTag,msg);
            ProxyMessage proxyMessage = RabbitMQMessageConsumerRegister.getMessage(message);
            for (ProxyMessageConsumer proxyMessageConsumer : localConsumers) {
                proxyMessageConsumer.onMessage(proxyMessage);
            }

            //TODO  未完成 在外部实现消息确认
            channel.basicAck(envelope.getDeliveryTag(), false);
        } catch (Exception e) {
            try {
                e.printStackTrace();
                // 处理失败，消息重新入队，等待下一次重试
                channel.basicNack(envelope.getDeliveryTag(), false, true);
            } catch (IOException ex) {
                ex.printStackTrace();
            }
        }
    }

    public Set<IProxyMessageConsumerWrapper> getLocalConsumers() {
        return localConsumers;
    }

    @Override
    public String toString() {
        return "RabbitMqMessageListener";
    }

    @Override
    public int hashCode() {
        return this.toString().hashCode();
    }

    @Override
    public boolean equals(Object obj) {
        return obj != null && obj.getClass() == this.getClass() && this.toString().equals(obj.toString());
    }
}
