/*
 * Decompiled with CFR 0.152.
 */
package com.ohaotian.plugin.mq.proxy.ext.rabbitmq;

import com.ohaotian.plugin.mq.proxy.ProxyMessage;
import com.ohaotian.plugin.mq.proxy.ProxyMessageType;
import com.ohaotian.plugin.mq.proxy.constants.Strategy;
import com.ohaotian.plugin.mq.proxy.ext.rabbitmq.RabbitMQUtil;
import com.ohaotian.plugin.mq.proxy.ext.rabbitmq.RabbitMqMessageListener;
import com.ohaotian.plugin.mq.proxy.impl.ConsumerRegisterInfo;
import com.ohaotian.plugin.mq.proxy.impl.MQRegister;
import com.rabbitmq.client.BuiltinExchangeType;
import com.rabbitmq.client.Channel;
import com.rabbitmq.client.Consumer;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.util.CollectionUtils;

public class RabbitMQMessageConsumerRegister
implements MQRegister,
ApplicationContextAware {
    private final Logger logger = LoggerFactory.getLogger((String)this.getClass().getName());
    private Properties mergedProps = new Properties();
    private boolean started;
    private Channel channel;
    private String exchangeName;

    @Override
    public void register(ConsumerRegisterInfo consumerInfo) {
        ProxyMessageType[] messageTypes;
        String subject = consumerInfo.getSubject();
        String queueName = consumerInfo.getQueueName();
        Set<String> tags = consumerInfo.getTags();
        List collect = tags.stream().collect(Collectors.toList());
        if (collect.size() != 1) {
            throw new IllegalArgumentException("Tags must have 1 element");
        }
        for (ProxyMessageType messageType : messageTypes = consumerInfo.getMessageTypes()) {
            if (this.supportConcurrently(messageType)) continue;
            throw new UnsupportedOperationException("Unsuppoorted messageType[" + (Object)((Object)messageType) + "] for subject[" + consumerInfo.getSubject() + "]");
        }
        try {
            Properties consumerProps = consumerInfo.getProperties();
            this.exchangeName = consumerProps.getProperty("mq.exchangeName", this.mergedProps.getProperty("mq.exchangeName"));
            this.channel = RabbitMQUtil.getChannelInstance("\u6d88\u8d39\u8005,\u961f\u5217\uff1a" + queueName, this.mergedProps);
            this.channel.exchangeDeclare(this.exchangeName, BuiltinExchangeType.TOPIC);
            this.channel.queueDeclare(queueName, false, false, false, null);
            this.channel.queueBind(queueName, this.exchangeName, subject);
            RabbitMqMessageListener rabbitMqMessageListener = new RabbitMqMessageListener(queueName, false, (String)collect.get(0), this.channel, consumerInfo.getConsumerWrappers());
            this.channel.basicConsume(queueName, (Consumer)rabbitMqMessageListener);
            this.logger.info("\u6d88\u8d39\u8005\u542f\u52a8\u6ce8\u518c\uff0c\u4ea4\u6362\u673a=" + this.exchangeName + "\uff0c\u961f\u5217\u540d\u79f0=" + queueName);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    protected static ProxyMessage getMessage(ProxyMessage proxyMessage) {
        return proxyMessage;
    }

    @Override
    public boolean support(String strategy) {
        return RabbitMQMessageConsumerRegister.strategySupported(strategy);
    }

    @Override
    public void startup() {
        if (this.started) {
            return;
        }
        this.started = true;
    }

    @Override
    public void shutdown() {
        if (!this.started) {
            return;
        }
        this.started = false;
    }

    public static boolean strategySupported(String strategy) {
        return Strategy.isRabbitMQ(strategy);
    }

    private boolean supportConcurrently(ProxyMessageType messageType) {
        return messageType == ProxyMessageType.ASYNCHRONOUS || messageType == ProxyMessageType.SYNCHRONIZATION || messageType == ProxyMessageType.ONEWAY || messageType == ProxyMessageType.TRANSACTION;
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        Map propsMapping = applicationContext.getBeansOfType(Properties.class);
        if (propsMapping != null) {
            for (Properties props : propsMapping.values()) {
                CollectionUtils.mergePropertiesIntoMap((Properties)props, (Map)this.mergedProps);
            }
        }
    }
}

