package com.ohaotian.plugin.mq.proxy.ext.rocketmq;

import com.ohaotian.plugin.mq.proxy.CacheStore;
import com.ohaotian.plugin.mq.proxy.ext.ProxyMqTransactionChecker;
import com.ohaotian.plugin.mq.proxy.status.ProxyTransactionStatus;
import org.apache.rocketmq.client.producer.LocalTransactionState;
import org.apache.rocketmq.client.producer.TransactionCheckListener;
import org.apache.rocketmq.common.message.MessageExt;

public class RocketMqTransactionCheckListener implements TransactionCheckListener {
    private ProxyMqTransactionChecker mqTransactionChecker = new ProxyMqTransactionChecker();

    public LocalTransactionState checkLocalTransactionState(MessageExt msg) {
        ProxyTransactionStatus transactionStatus = mqTransactionChecker.check(msg.getMsgId(), msg.getKeys(), msg.getTopic(), msg.getTags());
        switch (transactionStatus) {
            case ROLLBACK:
                return LocalTransactionState.ROLLBACK_MESSAGE;
            case COMMIT:
                return LocalTransactionState.COMMIT_MESSAGE;
            default:
                return LocalTransactionState.UNKNOW;
        }
    }

    public void setCacheStore(CacheStore cacheStore) {
        mqTransactionChecker.setCacheStore(cacheStore);
    }
}
