package com.ohaotian.plugin.mq.proxy;

/**
 * 标题：消息类型
 * <p>
 * 说明：消息类型
 * <br>
 * 时间：2018/06/25<br>
 * 版权：copyright © 2018 www.tydic.com Inc. All rights reserved.
 * </p>
 *
 * @author Please creater enter the name
 * @author ZhangCheng
 */
public enum ProxyMessageType {
    /**
     * 同步消息，发送者会阻塞等待消费者处理消息后的返回结果
     */
    SYNCHRONIZATION,
    /**
     * 异步消息，发送者发送消息时，同时传入回调对象，根据消费者的返回结果分别执行回调对象的方法
     */
    ASYNCHRONOUS,
    /**
     * 单向消息，发送者只管发送消息，不管消费者的返回结果
     */
    ONEWAY,
    /**
     * 半事务消息，发送者发送消息时，同时传入事务执行对象，并可以根据返回结果，决定提交执行或回滚
     */
    TRANSACTION,
    /**
     * // TODO 请补充注释 mark by zhangcheng on 2018/06/25
     */
    ORDERED

}
