package com.ohaotian.plugin.mq.proxy;

/**
 * 标题：缓存仓库
 * <p>
 * 说明：缓存仓库
 * <br>
 * 时间：2018/06/26<br>
 * 版权：copyright © 2018 www.tydic.com Inc. All rights reserved.
 * </p>
 *
 * @author Please creater enter the name
 * @author ZhangCheng
 */
public interface CacheStore {
    /***
     * 删除 数据
     * @param key Key
     */
    void delete(String key);

    /**
     * 设置 数据
     *
     * @param key    Key
     * @param value  值
     * @param expire 过期时间（// TODO 请补充时间单位 mark by zhangcheng on 2018/06/26）
     */
    void set(String key, Object value, int expire);

    /**
     * 获取 过期时间
     *
     * @param key Key
     * @return 过期时间
     */
    Long getExpireTimeByKey(String key);

    /**
     * 获取 数据
     *
     * @param key Key
     * @return 数据
     */
    Object get(String key);
}
