/*
 * Decompiled with CFR 0.152.
 */
package com.ohaotian.plugin.mq.proxy.impl;

import com.ohaotian.plugin.mq.proxy.ProxyMessageConsumer;
import com.ohaotian.plugin.mq.proxy.ProxyMessageType;
import com.ohaotian.plugin.mq.proxy.config.ApolloConfigVO;
import com.ohaotian.plugin.mq.proxy.constants.LogUtils;
import com.ohaotian.plugin.mq.proxy.constants.MessageConfigUtils;
import com.ohaotian.plugin.mq.proxy.ext.ExtInfo;
import com.ohaotian.plugin.mq.proxy.impl.ConsumerInvokeHandler;
import com.ohaotian.plugin.mq.proxy.impl.ConsumerRegisterInfo;
import com.ohaotian.plugin.mq.proxy.impl.IProxyMessageConsumerWrapper;
import com.ohaotian.plugin.mq.proxy.impl.MQRegister;
import com.ohaotian.plugin.mq.proxy.impl.MQUtils;
import com.ohaotian.plugin.mq.proxy.impl.ProxyProducerFactoryBean;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;

public class ProxyMessageRegister
implements ApplicationContextAware {
    private static final Logger logger = LoggerFactory.getLogger(ProxyMessageRegister.class);
    private String strategy;
    private String enable;
    List<MQRegister> registerList = new LinkedList<MQRegister>();

    public ProxyMessageRegister() {
        this.init();
    }

    private void init() {
        System.setProperty("rocketmq.client.log.loadconfig", "false");
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        ApolloConfigVO bean = (ApolloConfigVO)applicationContext.getBean(ApolloConfigVO.class);
        System.out.println(bean.toString());
        Boolean disable = MessageConfigUtils.isDisable(bean.getEnable());
        if (disable.booleanValue()) {
            LogUtils.info(logger, "\u7981\u7528\u63d2\u4ef6\uff0c\u7981\u7528\u6d88\u8d39\u8005\u6d88\u606f\u76d1\u542c");
            return;
        }
        LogUtils.info(logger, "\u542f\u7528\u63d2\u4ef6\uff0c\u542f\u7528\u6d88\u8d39\u8005\u6d88\u606f\u76d1\u542c");
        Map consumerMapping = applicationContext.getBeansOfType(ProxyMessageConsumer.class);
        Iterator consumers = consumerMapping.values().iterator();
        HashMap<String, ConsumerRegisterInfo> localStore = new HashMap<String, ConsumerRegisterInfo>();
        while (consumers.hasNext()) {
            ExtInfo extInfo;
            ProxyMessageType[] messageTypes;
            ProxyMessageConsumer consumer = (ProxyMessageConsumer)consumers.next();
            StringBuilder localStoreKey = new StringBuilder();
            localStoreKey.append(consumer.getSubject()).append("[");
            for (ProxyMessageType messageType : messageTypes = consumer.supportMessageTypes()) {
                localStoreKey.append(messageType.name()).append("-");
            }
            localStoreKey.append("]");
            ConsumerRegisterInfo consumerRegisterInfo = (ConsumerRegisterInfo)localStore.get(localStoreKey.toString());
            if (consumerRegisterInfo == null) {
                consumerRegisterInfo = new ConsumerRegisterInfo(consumer.getId(), consumer.getSubject(), new HashSet<String>(), consumer.supportMessageTypes(), new HashSet<IProxyMessageConsumerWrapper>(), consumer.getProperties(), consumer.getQueueName(), consumer.getMessageModel());
                localStore.put(localStoreKey.toString(), consumerRegisterInfo);
            }
            Set<String> tagSet = consumerRegisterInfo.getTags();
            String[] tags = consumer.getTags();
            ProxyProducerFactoryBean.trans2TagSet(tagSet, tags);
            Set<IProxyMessageConsumerWrapper> localConsumers = consumerRegisterInfo.getConsumerWrappers();
            IProxyMessageConsumerWrapper proxyMessageConsumerWrapper = (IProxyMessageConsumerWrapper)Proxy.newProxyInstance(this.getClass().getClassLoader(), new Class[]{IProxyMessageConsumerWrapper.class}, (InvocationHandler)new ConsumerInvokeHandler(consumer));
            localConsumers.add(proxyMessageConsumerWrapper);
            String localStrategy = bean.getStrategy();
            if (localStrategy == null || "".equals(localStrategy)) {
                localStrategy = this.strategy;
            }
            if ((extInfo = MQUtils.getExtInfoMapping().get(localStrategy)) == null) {
                throw new IllegalStateException("mq.strategy[" + localStrategy + "] unsupported");
            }
            MQRegister mqRegister = extInfo.newRegister();
            if (mqRegister instanceof ApplicationContextAware) {
                ((ApplicationContextAware)mqRegister).setApplicationContext(applicationContext);
            }
            this.registerList.add(mqRegister);
            mqRegister.register(consumerRegisterInfo, bean);
        }
        this.startup();
    }

    public void startup() {
        for (MQRegister register : this.registerList) {
            register.startup();
        }
    }

    public void shutdown() {
        for (MQRegister register : this.registerList) {
            register.shutdown();
        }
    }

    public void setStrategy(String strategy) {
        this.strategy = strategy;
    }

    public void setEnable(String enable) {
        this.enable = enable;
    }
}

